/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Configuration.java 1928 2008-07-30 08:45:19Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.graph.conf;

import java.text.SimpleDateFormat;

/**
 * Graph configuration.
 */
public interface Configuration {
    /**
     * Returns the series configuration for a given id.
     *
     * @param id  Series id.
     *
     * @return  Series configuration for that id.
     */
    SerieConfig getSerieConfig(final String id);

    /**
     * @return  All series ids currently registered.
     */
    String[] getSerieIds();

    /**
     * Returns the graph configuration for a given id.
     *
     * @param id  Graph id.
     *
     * @return  Graph configuration for that id.
     */
    GraphConfig getGraphConfig(final String id);

    /**
     * @return  All graph ids currently registered.
     */
    String[] getGraphIds();

    /**
     * Loads the configuration from a path.
     *
     * @param conf  Configuration file path. If null, the file path is set to
     *              the GRAPH_CONFIG_PATH system property.
     */
    void loadConfig(String conf);

    /**
     * @return  The value separator string.
     */
    String getSeparator();


    /**
     * @return  The absciss column title string.
     */
    String getAbscissColumn();

    /**
     * @return  The date format. If null, date format is long.
     */
    SimpleDateFormat getDateFormat();

    /**
     * Default separator.
     */
    String DEFAULT_SEPARATOR = ";";

    /**
     * Default complex date format.
     */
    String DEFAULT_DATE_FORMAT = "dd/MM/yyyy HH:mm:ss";

    /**
     * Default column used for absciss axe.
     */
    String DEFAULT_ABSCISS_COLUMN = "date";

    /**
     * Default column used for the series name.
     */
    String DEFAULT_MBEAN_COLUMN = "mbean";
}
