/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SerieConfig.java 1928 2008-07-30 08:45:19Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.graph.conf;

/**
 * Series configuration.
 */
public class SerieConfig extends Constants {
    /**
     * Creates a series configuration based on a Configuration parent.
     *
     * @param parent  Configuration parent.
     */
    public SerieConfig(final Configuration parent) {
        this.parent = parent;
    }

    /**
     * @return  Configuration parent.
     */
    public Configuration getParent() {
        return parent;
    }

    /**
     * @return  Series description.
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description  Series description to set.
     */
    public void setDescription(final String description) {
        this.description = description;
    }

    /**
     * @return  MBean pattern used for filtering.
     */
    public String getMbeanPattern() {
        return mbeanPattern;
    }

    /**
     * @param mbeanPattern  MBean pattern to set.
     */
    public void setMbeanPattern(final String mbeanPattern) {
        this.mbeanPattern = mbeanPattern;
    }

    /**
     * @return  Series title.
     */
    public String getTitle() {
        return title;
    }

    /**
     * @param title  New series title.
     */
    public void setTitle(final String title) {
        this.title = title;
    }

    /**
     * @return  Name of the X axis.
     */
    public String getXAxis() {
        return xAxis;
    }

    /**
     * @param axis  New name of the X axis.
     */
    public void setXAxis(final String axis) {
        xAxis = axis;
    }

    /**
     * @return  Type of the X axis.
     */
    public int getXType() {
        return xType;
    }

    /**
     * @param type  New type of the X axis.
     */
    public void setXType(final int type) {
        xType = type;
    }

    /**
     * @return  Name of the Y axis.
     */
    public String getYAxis() {
        return yAxis;
    }

    /**
     * @param axis  New name of the Y axis.
     */
    public void setYAxis(final String axis) {
        yAxis = axis;
    }

    /**
     * @return  Type of the Y axis.
     */
    public int getYType() {
        return yType;
    }

    /**
     * @param type  New type of the Y axis.
     */
    public void setYType(final int type) {
        yType = type;
    }

    /**
     * @return  Series identifier.
     */
    public String getId() {
        return id;
    }

    /**
     * @param id  New series identifier.
     */
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * Identifier.
     */
    private String id = null;

    /**
     * Title.
     */
    private String title = null;

    /**
     * Name of the X axis.
     */
    private String xAxis = null;

    /**
     * Data type of the X axis.
     */
    private int xType = Constants.LONG;

    /**
     * Name of the Y axis.
     */
    private String yAxis = null;

    /**
     * Data type of the Y axis.
     */
    private int yType = Constants.LONG;

    /**
     * MBean pattern used for filtering.
     */
    private String mbeanPattern = null;

    /**
     * Series description.
     */
    private String description = null;

    /**
     * Parent Configuration.
     */
    private Configuration parent = null;
}
