/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CmdLoaderHelper.java 4292 2009-07-07 12:58:43Z jlegrand $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.loader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

/**
 * @author WAESELYNCK-F
 *
 */
public class CmdLoaderHelper {

    /**
     * @return
     */
    @SuppressWarnings("unchecked")
    public static URL[] getXClasspath() {

        ArrayList<URL> list = new ArrayList();
        URL[] urls = new URL[] { null };
        
        String fileSep = System.getProperty("file.separator");
        String pathSep = System.getProperty("path.separator");
        String[] pathes = null;
        String cpath = System.getProperty("jasmine.jmx.xclasspath");
        if (cpath != null) {
            pathes = cpath.split(pathSep);
    
            for (int i = 0; i < pathes.length; i++) {
                URL url = null;
                /*
                 * If pathes[i] is an URL, add it to the list as it is.
                 * otherwise it is assumed to be a path to a file or directory
                 * Note that for URL classloader :
                 * - if the URL ends with "/" it refers to a directory
                 * - otherwise it refers to a jar file.
                 * So Don't forget trailing "/" in URLs, il applicable
                 */
                try {
                    url = new URL(pathes[i]);
                    list.add(url);
                } catch (MalformedURLException e1) {
                    // Nothing to do
                }
                
                /*
                 * if path is not an URL
                 * - and has no .jar extension nor triling "/"
                 * then it is assumed to be a directory: appends a trailing "/"  
                 */
                if ((url == null) && (pathes[i].length() != 0)) {
                    if (!(pathes[i].endsWith(".jar") || pathes[i].endsWith(fileSep))) {
                        pathes[i] = pathes[i] + fileSep;
                    }
                    try {
                        URL u = (new File(pathes[i])).toURI().toURL();
                        list.add((new File(pathes[i])).toURI().toURL());
                    } catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        URL[] result = null;
        if (list.size() > 0) {
            result = list.toArray(urls);
        }
        return result;
    }
        
}
