/**
 * JASMINe
 * Copyright (C) 2005-2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EntityData.java 7290 2010-12-09 07:58:04Z joaninh $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.HashMap;
import java.util.Map;


/**
 * Data retrieved from entity beans.
 */
public class EntityData extends SampleData {
    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#compute(SampleData)
     */
    public void compute(final SampleData needs_cast) {
        EntityData prev = (EntityData) needs_cast;
        // nothing to do
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintHeader()
     */
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", getSeparator());
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintData()
     */
    protected String getInnerPrintData() {
        Integer[] counters = (Integer[]) this.getAttribute("entityCounters");
        StringBuffer stringBuff = new StringBuffer();
        concatDataElement(stringBuff, this.getAttributeAsInt("cacheSize"), false); // Total nb of instances in memory
        concatDataElement(stringBuff, this.getAttributeAsInt("poolSize"), false);  // Current nb of free instances
        concatDataElement(stringBuff, this.getAttributeAsInt("minPoolSize"), false);
        concatDataElement(stringBuff, this.getAttributeAsInt("maxCacheSize"), false);
        concatDataElement(stringBuff, counters[0], false); // Current nb of instances used inside transactions
        concatDataElement(stringBuff, counters[1], false); // Current nb of instances used outside transactions
        concatDataElement(stringBuff, counters[2], false); // Current nb of unused, ready instances
        concatDataElement(stringBuff, counters[3], false); // Current nb of instances marked removed
        concatDataElement(stringBuff, counters[4], false); // Total nb of PK in memory
        concatDataElement(stringBuff, counters[5], true); // Current nb of passivated instances
        return new String(stringBuff);
    }

    @Override
    public Map<String, ?> getValueOfAttributes() {
        Integer[] counters = (Integer[]) this.getAttribute("entityCounters");
        HashMap<String, Object> valueOfAttributes = new HashMap<String, Object>();
        valueOfAttributes.put("cacheSize", getAttributeAsInt("cacheSize"));
        valueOfAttributes.put("poolSize", getAttributeAsInt("poolSize"));
        valueOfAttributes.put("minPoolSize", getAttributeAsInt("minPoolSize"));
        valueOfAttributes.put("maxCacheSize", getAttributeAsInt("maxCacheSize"));
        valueOfAttributes.put("usedInTx", counters[0]);
        valueOfAttributes.put("usedOutTx", counters[1]);
        valueOfAttributes.put("unusedReady", counters[2]);
        valueOfAttributes.put("markedRemoved", counters[3]);
        valueOfAttributes.put("pkNumber", counters[4]);
        valueOfAttributes.put("passivated", counters[5]);
        return valueOfAttributes;
    }

    /**
     * Default output header.
     */
    private static final String header = "cacheSize;poolSize;minPoolSize;maxCacheSize;"
                                       + "usedInTx;usedOutTx;unusedReady;markedRemoved;pkNumber;passivated";
}
