/**
 * JASMINe
 * Copyright (C) 2005-2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JoramQData.java 6228 2010-03-30 09:30:31Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.HashMap;
import java.util.Map;

import javax.management.Attribute;

/**
 * Data retrieved from JCA Connection Factories.
 */
public class JoramQData extends SampleData {
    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#compute(SampleData)
     */
    public void compute(final SampleData needs_cast) {
        JoramQData prev = (JoramQData) needs_cast;
        if (prev != null) {
            // receive Rate : number of inqueud msg per second
            long deltaReceived = this.getAttributeAsLong("NbMsgsReceiveSinceCreation") - prev.getAttributeAsLong("NbMsgsReceiveSinceCreation");
            double dt = (this.getSampleTime() - prev.getSampleTime()) / 1000.0;
            this.setAttribute(new Attribute("receiveRate", new Double(deltaReceived / dt)));

            // delivery Rate : number of msg deliveries per second
            long deltaDelivery = this.getAttributeAsLong("NbMsgsDeliverSinceCreation") - prev.getAttributeAsLong("NbMsgsDeliverSinceCreation");
            this.setAttribute(new Attribute("deliveryRate", new Double(deltaDelivery / dt)));
        } else {
            this.setAttribute(new Attribute("receiveRate", new Double(0.0)));
            this.setAttribute(new Attribute("deliveryRate", new Double(0.0)));
        }
    }


    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintHeader()
     */
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", getSeparator());
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintData()
     */
    protected String getInnerPrintData() {

        /*
         * JORAM 5: NbMsgsSentToDMQSinceCreation
         * JORAM 4: NbMsgsSendToDMQSinceCreation
         */
        Long msgToDMQCount = 0L;
        try {
            // Try to retrieve a JORAM 5 attribute
            msgToDMQCount = this.getAttributeAsLong("NbMsgsSentToDMQSinceCreation");
        } catch(java.lang.NullPointerException e) {
            // If NPE is raised, try a JORAM 4 attribute - ignore exception
        }
        if (msgToDMQCount == null) {
            msgToDMQCount = this.getAttributeAsLong("NbMsgsSendToDMQSinceCreation");
        }

        return  this.getAttribute("AdminName") + getSeparator()
                + this.getAttributeAsInt("PendingMessageCount") + getSeparator()
                + this.getAttributeAsInt("NbMaxMsg") + getSeparator()
                + decimalFormat.format(this.getAttributeAsDouble("receiveRate")) + getSeparator()
                + decimalFormat.format(this.getAttributeAsDouble("deliveryRate")) + getSeparator()
                + this.getAttributeAsInt("WaitingRequestCount") + getSeparator()
                + this.getAttributeAsLong("CreationTimeInMillis") + getSeparator()
                + this.getAttributeAsLong("NbMsgsReceiveSinceCreation") + getSeparator()
                + this.getAttributeAsLong("NbMsgsDeliverSinceCreation") + getSeparator()
                + msgToDMQCount;
    }

    @Override
    public Map<String, ?> getValueOfAttributes() {
        HashMap<String, Object> valueOfAttributes = new HashMap<String, Object>();
        valueOfAttributes.put("AdminName", getAttribute("AdminName"));
        valueOfAttributes.put("PendingMessageCount", getAttributeAsInt("PendingMessageCount"));
        valueOfAttributes.put("NbMaxMsg", getAttributeAsInt("NbMaxMsg"));
        valueOfAttributes.put("receiveRate", getAttributeAsDouble("receiveRate"));
        valueOfAttributes.put("deliveryRate", getAttributeAsDouble("deliveryRate"));
        valueOfAttributes.put("WaitingRequestCount", getAttributeAsInt("WaitingRequestCount"));
        valueOfAttributes.put("CreationTimeInMillis", getAttributeAsLong("creationDate"));
        valueOfAttributes.put("nbMsgsReceiveSinceCreation", getAttributeAsLong("nbMsgsReceiveSinceCreation"));
        valueOfAttributes.put("nbMsgsDeliverSinceCreation", getAttributeAsLong("nbMsgsDeliverSinceCreation"));
        valueOfAttributes.put("nbMsgsSentToDMQSinceCreation", getAttributeAsLong("nbMsgsSentToDMQSinceCreation"));
        return valueOfAttributes;
    }

    /**
     * Default output header.
     */
    private static final String header =
        "AdminName;PendingMessages;NbMaxMsg;receiveRate;deliveryRate;PendingRequests;"
        + "creationDate;nbMsgsReceiveSinceCreation;nbMsgsDeliverSinceCreation;nbMsgsSentToDMQSinceCreation" ;
}
