/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SessionBeanSampler.java 6157 2010-03-16 14:39:48Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Set;

import javax.management.ObjectName;

import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;

/**
 * Sampler for retrieving data from stateless session beans.
 */
public abstract class SessionBeanSampler extends Sampler {

    public SessionBeanSampler(SamplerContext context) {
        super(context);
    }

    @Override
    protected abstract String getDefaultOnPattern();

    @Override
    protected SampleData newSampleData() {
        return new XSampleData();
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see Sampler#poll(SampleData)
     */
    protected SampleData poll(final SampleData data) {
        pollSessionBeans((XSampleData) data);
        data.setValid(true);
        return data;
    }

    /**
     * Polls stateless bean providers for data, will call
     * {@link SLBSampler#pollSLB(ObjectName, SLBData)}
     * for each object name.
     *
     * @param data  XSampleData to add polled information to.
     */
    protected void pollSessionBeans(final XSampleData data) {
        Set<ObjectName> sons = context.getOnames();
        ObjectName[] oNames = (ObjectName[]) sons.toArray(new ObjectName[sons.size()]);

        for (int i = 0; i < oNames.length; i++) {
            SessionBeanData sessionData = new SessionBeanData();
            sessionData.setObjectName(oNames[i]);
            sessionData.setSampleTime(System.currentTimeMillis());
            pollSessionBean(oNames[i], sessionData);

            if (sessionData.isValid()) {
                data.put(oNames[i], sessionData);
            }
        }
    }

    protected abstract void pollSessionBean(final ObjectName on, final SessionBeanData data);
}
