/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.ow2.jasmine.monitoring.mbeancmd.generated.ObjectFactory;
import org.ow2.jasmine.monitoring.mbeancmd.generated.ProbeConfig;
import org.ow2.jasmine.monitoring.mbeancmd.generated.Target;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JmxHelper {
    private static Log logger = LogFactory.getLog(JmxHelper.class);
    public static final String DEFAULT_URL = "service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas";
    public static final String DEFAULT_FILE = "probe-config.xml";
    public static final String DEFAULT_CONFIG_FILE = "probe-config.xml";
    private static Map<String, String> jmxTargets = new TreeMap<String, String>();
    private static Map<String, String> jmxUsers = new TreeMap<String, String>();
    private static Map<String, String> jmxPasswords = new TreeMap<String, String>();
    private static Map<String, String> jmxProtocolProviderPackages = new TreeMap<String, String>();
    private static String defaultTarget = null;
    private static Context ctx = null;

    public static Context getContext() {
        if (ctx != null) {
            return ctx;
        }
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Error while creating initialContext : {0}. An unmanaged JMX connection will be used instead.", new Object[]{e.getMessage()});
        }
        return ctx;
    }

    public static String getDefaultJmxTarget() {
        if (defaultTarget != null) {
            return jmxTargets.get(defaultTarget);
        }
        return null;
    }

    public static String getDefaultTarget() {
        return defaultTarget;
    }

    public static String getJmxUser(String jmxUrl) {
        return jmxUsers.get(jmxUrl);
    }

    public static String getJmxPassword(String jmxUrl) {
        return jmxPasswords.get(jmxUrl);
    }

    public static String getJmxProtocolProviderPackage(String jmxUrl) {
        return jmxProtocolProviderPackages.get(jmxUrl);
    }

    public static String getJmxUrl(String name) {
        if (name == null) {
            return jmxTargets.get(defaultTarget);
        }
        if (name.startsWith("service:jmx:rmi")) {
            return name;
        }
        return jmxTargets.get(name);
    }

    public static String[] getJmxTargets() {
        String[] targets = null;
        if (!jmxTargets.isEmpty()) {
            targets = new String[jmxTargets.size()];
            targets = jmxTargets.keySet().toArray(targets);
        }
        return targets;
    }

    public static String[] getJmxTargets(String[] proposed) {
        int i;
        boolean all = false;
        String[] targetsArray = null;
        LinkedList<String> targetsList = new LinkedList<String>();
        if (proposed != null) {
            for (i = 0; i < proposed.length; ++i) {
                if ("all".equalsIgnoreCase(proposed[i])) {
                    all = true;
                    break;
                }
                String url = JmxHelper.getJmxUrl(proposed[i]);
                if (url != null) {
                    targetsList.add(proposed[i]);
                    continue;
                }
                logger.info((Object)"Target {0} is not defined in configuration file. Please check the probe-config.xml.", new Object[]{proposed[i]});
            }
        } else if (defaultTarget != null) {
            targetsList.add(defaultTarget);
        }
        if (all) {
            targetsArray = JmxHelper.getJmxTargets();
        } else {
            targetsArray = new String[targetsList.size()];
            for (i = 0; i < targetsList.size(); ++i) {
                targetsArray[i] = (String)targetsList.get(i);
            }
        }
        return targetsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() {
        Log logger = LogFactory.getLog(JmxHelper.class);
        String defaultUrl = System.getProperty("jasmine.jmx.url");
        if (defaultUrl != null) {
            String defaultName = null;
            if (defaultUrl.matches(".*connector_.*")) {
                int ix = defaultUrl.lastIndexOf("connector_");
                defaultName = defaultUrl.substring(ix + "connector_".length());
            } else {
                defaultName = defaultUrl;
            }
            defaultTarget = defaultName;
        }
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        InputStream resource = null;
        try {
            resource = loader.getResourceAsStream("probe-config.xml");
            if (resource == null) {
                resource = new FileInputStream(new File("probe-config.xml"));
            }
        }
        catch (Exception e) {
            if (defaultUrl == null) {
                logger.error((Object)"No default target defined with jasmine.jmx.url property, and cannot find probe-config.xml", new Object[0]);
            } else {
                jmxTargets.put(defaultTarget, defaultUrl);
            }
            return;
        }
        logger.debug((Object)"Parsing probe-config.xml", new Object[0]);
        ProbeConfig probeConfig = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            probeConfig = (ProbeConfig)unmarshaller.unmarshal(resource);
            for (Target target : probeConfig.getTarget()) {
                String name = target.getId();
                String url = target.getUrl();
                jmxTargets.put(name, url);
                String user = target.getUser();
                jmxUsers.put(url, user);
                String password = target.getPassword();
                jmxPasswords.put(url, password);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                resource.close();
            }
            catch (IOException ignore) {}
        }
        if (defaultUrl != null) {
            jmxTargets.put(defaultTarget, defaultUrl);
        }
    }

    private static Properties getProperties(File propertyFile) throws IOException {
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream(propertyFile);
        properties.load(in);
        in.close();
        return properties;
    }

    static {
        JmxHelper.load();
    }
}

