/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.IOException;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;
import org.ow2.jasmine.monitoring.mbeancmd.context.DumpContext;

public class Dump
extends AbstractCommand {
    private DumpContext[] contexts = null;
    private Options options = null;
    private CommandLine commandLine = null;
    private ObjectName on = null;
    private CommandDispatcher cmdDispatcher = null;
    private String outputFilePath = null;
    private boolean logger = false;

    public Dump() {
        this.setOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec(CommandDispatcher cmdDispatcher) {
        this.cmdDispatcher = cmdDispatcher;
        try {
            if (this.arguments == null) {
                this.arguments = new String[1];
                this.arguments[0] = "";
            }
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        String[] targets = JmxHelper.getJmxTargets(this.commandLine.getOptionValues("target"));
        if (targets != null && targets.length > 0) {
            this.contexts = new DumpContext[targets.length];
            for (int i = 0; i < this.contexts.length; ++i) {
                this.contexts[i] = new DumpContext();
                this.contexts[i].setName(targets[i]);
                this.contexts[i].setJmxUrl(JmxHelper.getJmxUrl(targets[i]));
                this.contexts[i].setJmxap(new JmxAp(this.contexts[i].getJmxUrl(), this.cmdDispatcher));
                this.contexts[i].setAdminNaming(false);
                try {
                    ObjectName j2eeinstance = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
                    MBeanServerConnection mbscnx = this.contexts[i].getJmxap().getMBeanServerConnection();
                    Iterator<ObjectName> onames = mbscnx.queryNames(j2eeinstance, null).iterator();
                    this.contexts[i].setServer(null);
                    while (this.contexts[i].getServer() == null) {
                        ObjectName server = onames.next();
                        this.contexts[i].setServer((String)mbscnx.getAttribute(server, "serverName"));
                        this.contexts[i].setDomain(server.getDomain());
                    }
                }
                catch (Exception e) {
                    this.contexts[i].setServer("unknown_server_name");
                    this.contexts[i].setDomain("unknown_domain");
                }
                finally {
                    this.contexts[i].getJmxap().releaseMBeanServerConnection();
                }
                System.out.println("Target " + this.contexts[i].getName() + " - " + this.contexts[i].getJmxUrl());
            }
        } else {
            System.err.println("Target not found.");
            return 1;
        }
        this.getStackDump();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStackDump() {
        MBeanServerConnection cnx = null;
        String serverName = "";
        String domainName = "";
        for (int i = 0; i < this.contexts.length; ++i) {
            DumpContext ctx = this.contexts[i];
            serverName = this.contexts[i].getServer();
            domainName = this.contexts[i].getDomain();
            try {
                this.setObjectName(domainName, serverName);
                cnx = ctx.getJmxap().getMBeanServerConnection();
                ctx.setOnames(cnx.queryNames(this.on, null));
                for (ObjectName onGot : ctx.getOnames()) {
                    String opname = "";
                    try {
                        if (this.outputFilePath != null) {
                            opname = "printThreadStackDump";
                            Object[] opParams = new Object[]{this.outputFilePath};
                            String[] opSig = new String[]{String.class.getName()};
                            cnx.invoke(onGot, opname, opParams, opSig);
                        }
                        if (this.logger) {
                            opname = "logThreadStackDump";
                            cnx.invoke(onGot, opname, null, null);
                        }
                        if (this.outputFilePath != null || this.logger) continue;
                        opname = "threadStackDump";
                        System.out.println(cnx.getAttribute(onGot, opname));
                    }
                    catch (InstanceNotFoundException e) {
                        System.err.println("Not available. Missing required mbean (" + onGot + ")");
                        System.err.println("Run JOnAS on JDK 1.5 and enable management.");
                    }
                    catch (Exception e) {
                        System.err.println("Could not invoke \"" + opname + "\" on server \"" + serverName + "\"");
                        e.printStackTrace();
                    }
                }
                continue;
            }
            catch (MalformedObjectNameException e) {
                System.err.println("Not available. Couldn't find mbean on server " + serverName);
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                System.err.println("Not available. Couldn't find mbean on server " + serverName);
                e.printStackTrace();
                continue;
            }
            finally {
                ctx.getJmxap().releaseMBeanServerConnection();
            }
        }
    }

    public void parseCommandLine(String[] args) throws ParseException, MalformedObjectNameException {
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        if (this.commandLine.hasOption("l")) {
            this.logger = true;
        }
        if (this.commandLine.hasOption("f")) {
            this.outputFilePath = this.commandLine.getOptionValue("f");
        }
    }

    private void setObjectName(String domain, String server) throws MalformedObjectNameException {
        this.on = new ObjectName(domain + ":j2eeType=J2EEServer,name=" + server);
    }

    private void setOptions() {
        this.options = new Options();
        Option file = new Option("f", "file", true, "Print thread stack dump in a given file");
        file.setRequired(false);
        file.setOptionalArg(false);
        file.setArgName("file name");
        file.setArgs(1);
        this.options.addOption(file);
        Option log = new Option("l", "log", false, "Print thread stack dump in a JOnAS log file");
        log.setRequired(false);
        this.options.addOption(log);
        Option target = new Option("target", "target", true, "instances to get thread dump from");
        target.setRequired(false);
        target.setOptionalArg(true);
        target.setArgs(-2);
        target.setArgName("instances");
        this.options.addOption(target);
    }

    public String summary() {
        return "Dumps a thread stack from the JVM into stdout";
    }

    public static void main(String[] args) {
        Dump d = new Dump();
        d.setArgs("dump", args);
        d.exec(null);
    }
}

