/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.LogRecord;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.ow2.jasmine.monitoring.mbeancmd.context.MonologContext;

class MonologNotificationListener
implements NotificationListener {
    String header = "date;time;sname;server;domain;mbean;timestamp;stamp;sequence;loggername;level;message";
    boolean isHeaderSent = false;
    MonologContext context = null;
    public static final SimpleDateFormat SIMPLEDATEFORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    PrintStream out = null;

    public MonologNotificationListener(PrintStream out, MonologContext context) {
        this.out = out;
        this.context = context;
    }

    public void handleNotification(Notification nf, Object arg1) {
        LogRecord record = (LogRecord)nf.getUserData();
        StringBuffer bf = new StringBuffer();
        if (!this.isHeaderSent) {
            bf.append(this.header);
            bf.append("\n");
            this.isHeaderSent = !this.isHeaderSent;
        }
        bf.append(this.getHeaderBody());
        bf.append(";");
        bf.append(new Date(record.getMillis()));
        bf.append(";");
        bf.append(record.getMillis());
        bf.append(";");
        bf.append(record.getSequenceNumber());
        bf.append(";");
        bf.append(record.getLoggerName());
        bf.append(";");
        bf.append(record.getLevel().toString());
        bf.append(";");
        bf.append(record.getMessage());
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            bf.append(" - " + throwable.toString());
        }
        bf.append("\n");
        this.out.print(bf.toString());
    }

    private String getHeaderBody() {
        StringBuffer buff = new StringBuffer();
        long time = System.currentTimeMillis();
        buff.append(SIMPLEDATEFORMAT.format(new Date(time)));
        buff.append(";");
        buff.append(time);
        buff.append(";");
        buff.append(this.context.getJmxUrl());
        buff.append(";");
        buff.append(this.context.getServer());
        buff.append(";");
        buff.append(this.context.getDomain());
        buff.append(";");
        buff.append("jonas:type=service,name=log,fname=trace");
        return buff.toString();
    }
}

