/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCACFData
extends SampleData {
    private static final String header = "servedRate;servedOpen;maxSize;currentOpen;currentBusy;busyMax;currentWaiters;waitersHighRecent;waitingHighRecent;meanWaitTime;rejectedOpen;connectionLeaks";

    @Override
    public void compute(SampleData needs_cast) {
        JCACFData prev = (JCACFData)needs_cast;
        if (prev != null) {
            double sampleTime = this.computeSamplePeriod(prev);
            int deltaServedOpen = this.getAttributeAsInt("servedOpen") - prev.getAttributeAsInt("servedOpen");
            this.setAttribute(new Attribute("servedOpenRate", new Double((double)deltaServedOpen / sampleTime)));
            int deltaWaiterCount = this.getAttributeAsInt("waiterCount") - prev.getAttributeAsInt("waiterCount");
            long deltaWaitingTime = this.getAttributeAsLong("waitingTime") - prev.getAttributeAsLong("waitingTime");
            double meanWaitTime = deltaWaiterCount > 0 ? 1.0 * (double)deltaWaitingTime / (double)deltaWaiterCount : 0.0;
            this.setAttribute(new Attribute("meanWaitTime", new Double(meanWaitTime)));
        } else {
            this.setAttribute(new Attribute("servedOpenRate", new Double(0.0)));
            this.setAttribute(new Attribute("meanWaitTime", new Double(0.0)));
        }
    }

    @Override
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", JCACFData.getSeparator());
    }

    @Override
    protected String getInnerPrintData() {
        return decimalFormat.format(this.getAttributeAsDouble("servedOpenRate")) + JCACFData.getSeparator() + this.getAttributeAsInt("servedOpen") + JCACFData.getSeparator() + this.getAttributeAsInt("maxSize") + JCACFData.getSeparator() + this.getAttributeAsInt("currentOpened") + JCACFData.getSeparator() + this.getAttributeAsInt("currentBusy") + JCACFData.getSeparator() + this.getAttributeAsInt("busyMax") + JCACFData.getSeparator() + this.getAttributeAsInt("currentWaiters") + JCACFData.getSeparator() + this.getAttributeAsInt("waitersHighRecent") + JCACFData.getSeparator() + this.getAttributeAsLong("waitingHighRecent") + JCACFData.getSeparator() + decimalFormat.format(this.getAttributeAsDouble("meanWaitTime")) + JCACFData.getSeparator() + this.getAttributeAsInt("rejectedOpen") + JCACFData.getSeparator() + this.getAttributeAsInt("connectionLeaks");
    }

    @Override
    public Map<String, ?> getValueOfAttributes() {
        HashMap<String, Number> valueOfAttributes = new HashMap<String, Number>();
        valueOfAttributes.put("servedRate", this.getAttributeAsDouble("servedOpenRate"));
        valueOfAttributes.put("servedOpen", this.getAttributeAsInt("servedOpen"));
        valueOfAttributes.put("maxSize", this.getAttributeAsInt("maxSize"));
        valueOfAttributes.put("currentOpen", this.getAttributeAsInt("currentOpened"));
        valueOfAttributes.put("currentBusy", this.getAttributeAsInt("currentBusy"));
        valueOfAttributes.put("busyMax", this.getAttributeAsInt("busyMax"));
        valueOfAttributes.put("currentWaiters", this.getAttributeAsInt("currentWaiters"));
        valueOfAttributes.put("waitersHighRecent", this.getAttributeAsInt("waitersHighRecent"));
        valueOfAttributes.put("waitingHighRecent", this.getAttributeAsLong("waitingHighRecent"));
        valueOfAttributes.put("meanWaitTime", this.getAttributeAsDouble("meanWaitTime"));
        valueOfAttributes.put("rejectedOpen", this.getAttributeAsInt("rejectedOpen"));
        valueOfAttributes.put("connectionLeaks", this.getAttributeAsInt("connectionLeaks"));
        return valueOfAttributes;
    }
}

