/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Set;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SessionBeanData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XSampleData;

public abstract class SessionBeanSampler
extends Sampler {
    public SessionBeanSampler(SamplerContext context) {
        super(context);
    }

    protected abstract String getDefaultOnPattern();

    protected SampleData newSampleData() {
        return new XSampleData();
    }

    protected SampleData poll(SampleData data) {
        this.pollSessionBeans((XSampleData)data);
        data.setValid(true);
        return data;
    }

    protected void pollSessionBeans(XSampleData data) {
        Set<ObjectName> sons = this.context.getOnames();
        ObjectName[] oNames = sons.toArray(new ObjectName[sons.size()]);
        for (int i = 0; i < oNames.length; ++i) {
            SessionBeanData sessionData = new SessionBeanData();
            sessionData.setObjectName(oNames[i]);
            sessionData.setSampleTime(System.currentTimeMillis());
            this.pollSessionBean(oNames[i], sessionData);
            if (!sessionData.isValid()) continue;
            data.put(oNames[i], sessionData);
        }
    }

    protected abstract void pollSessionBean(ObjectName var1, SessionBeanData var2);
}

