/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AttributesOldValues.java 7353 2010-12-20 15:45:16Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.mbeancmd.context;

import java.util.HashMap;

import javax.management.ObjectName;

/**
 * Allows to manage the old values of some attributes corresponding to
 * a MBean polled by a command.
 * @author danesa
 *
 */
public class AttributesOldValues {

    private ObjectName on = null;

    /**
     * Maps attribute name to attribute value.
     */
    private HashMap<String, Object> oldValues = new HashMap<String, Object>();

    public void setOn(final ObjectName on) {
        this.on = on;
    }

    public void setOldValues(final HashMap<String, Object> currentValues) {
        this.oldValues = currentValues;
    }

    public void setOldValue(final String attName, final Object currentValue) {
        oldValues.put(attName, currentValue);
    }

    public Object getOldValue(final String attName) {
        return oldValues.get(attName);
    }

}
