/**
 * JASMINe
 * Copyright (C) 2007-2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: StatContext.java 8156 2011-05-13 15:40:30Z jlegrand $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.context;

import java.util.HashMap;

import javax.management.ObjectName;


/**
 * Statistic context.
 * @author Guillaume Renault
 */
public class StatContext extends JmxContext {

    /**
     *
     */
    private static final long serialVersionUID = 6899130652150941073L;

    private HashMap<String, AttributesOldValues> oldValuesMap;

    /**
     * Refresh timeout.
     */
    protected long refreshDeadLine = 0;

    /**
     * StatContext constructor.
     * @param oldValues if true, the StatContext provides for old attributes values management.
     */
    public StatContext(boolean oldValues) {
        if (oldValues) {
            oldValuesMap = new HashMap<String, AttributesOldValues>();
        }
    }

    public long getRefreshDeadLine() {
        return refreshDeadLine;
    }

    public void setRefreshDeadLine(long refreshDeadLine) {
        this.refreshDeadLine = refreshDeadLine;
    }

    public Object getOldValue(ObjectName on, String attName) {
        Object value = null;
        AttributesOldValues oldValues = oldValuesMap.get(on.toString());
        if (oldValues != null) {
            return oldValues.getOldValue(attName);
        }
        return value;
    }

    public void setOldValue(ObjectName on, String attName, Object currentValue) {
        String key = on.toString();
        AttributesOldValues oldValues = null;
        if (oldValuesMap.containsKey(key)) {
            oldValues = oldValuesMap.get(key);
        } else {
            oldValues = new AttributesOldValues();
            oldValues.setOn(on);
            oldValuesMap.put(key, oldValues);
        }
        oldValues.setOldValue(attName, currentValue);
    }

}
