/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SessionBeanData.java 6031 2010-02-08 08:19:03Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.HashMap;
import java.util.Map;

/**
 * Data retrieved from session beans.
 */
public class SessionBeanData extends SampleData {

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#compute(SampleData)
     */
    public void compute(final SampleData needs_cast) {
        SessionBeanData prev = (SessionBeanData) needs_cast;
        if (prev != null) {
        	double sampleTime = this.computeSamplePeriod(prev);
            // compute calls rate (nb calls / sec)
        	long deltaCalls = this.numberOfCalls - prev.numberOfCalls;
        	this.setCallsRate(deltaCalls / sampleTime);

        	// compute processing time per call
        	if (deltaCalls > 0) {
            	long deltaProcessingTime = this.totalProcessingTime - prev.totalProcessingTime;
            	this.setTotalProcessingTimeRequest(1.0 * deltaProcessingTime / deltaCalls);
        	}
        }
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintHeader()
     */
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", getSeparator()) + headerExt.replaceAll(";", getSeparator());
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see SampleData#getInnerPrintData()
     */
    protected String getInnerPrintData() {
        StringBuffer stringBuff = new StringBuffer();
        concatDataElement(stringBuff, this.getAttributeAsInt("cacheSize"), false);
        concatDataElement(stringBuff, this.getAttributeAsInt("poolSize"), false);
        concatDataElement(stringBuff, this.getAttributeAsInt("minPoolSize"), false);
        concatDataElement(stringBuff, this.getAttributeAsInt("maxCacheSize"), false);
        concatDataElement(stringBuff, this.getAttributeAsInt("sessionTimeOut"), false);
        /**
         * averageProcessingTime is in stand by till EasyBeans issue EZB-411 not fixed
        concatDataElement(stringBuff, this.getAverageProcessingTime(), false);
        */
        concatDataElement(stringBuff, this.getTotalProcessingTime(), false);
        concatDataElement(stringBuff, decimalFormat.format(this.getTotalProcessingTimeRequest()), false);
        concatDataElement(stringBuff, this.getNumberOfCalls(), false);
        concatDataElement(stringBuff, decimalFormat.format(this.getCallsRate()), true);
        return new String(stringBuff);
    }

    @Override
    public Map<String, ?> getValueOfAttributes() {
        HashMap<String, Object> valueOfAttributes = new HashMap<String, Object>();
        valueOfAttributes.put("cacheSize", getAttributeAsInt("cacheSize"));
        valueOfAttributes.put("poolSize", getAttributeAsInt("poolSize"));
        valueOfAttributes.put("minPoolSize", getAttributeAsInt("minPoolSize"));
        valueOfAttributes.put("maxCacheSize", getAttributeAsInt("maxCacheSize"));
        valueOfAttributes.put("sessionTimeOut", getAttributeAsInt("sessionTimeOut"));
        /**
         * averageProcessingTime is in stand by till EasyBeans issue EZB-411 not fixed
        valueOfAttributes.put("averageProcessingTime", getAverageProcessingTime());
         */
        valueOfAttributes.put("totalProcessingTime", getTotalProcessingTime());
        valueOfAttributes.put("totalProcessingTimeReq", getTotalProcessingTimeRequest());
        valueOfAttributes.put("numberOfCalls", getNumberOfCalls());
        valueOfAttributes.put("callsRate", getCallsRate());
        return valueOfAttributes;
    }

    /**
     * Calls count
     */
    private long numberOfCalls;

    /**
     * Calls rate (computed)
     */
    private double callsRate;

    public long getNumberOfCalls() {
		return numberOfCalls;
	}

	public void setNumberOfCalls(long numberOfCalls) {
		this.numberOfCalls = numberOfCalls;
	}

	public double getCallsRate() {
		return callsRate;
	}

	public void setCallsRate(double callsRate) {
		this.callsRate = callsRate;
	}

	public long getAverageProcessingTime() {
		return averageProcessingTime;
	}

	public void setAverageProcessingTime(long averageProcessingTime) {
		this.averageProcessingTime = averageProcessingTime;
	}

	public double getAverageProcessingTimeRequest() {
		return averageProcessingTimeRequest;
	}

	public void setAverageProcessingTimeRequest(double averageProcessingTimeRequest) {
		this.averageProcessingTimeRequest = averageProcessingTimeRequest;
	}

	public long getTotalProcessingTime() {
		return totalProcessingTime;
	}

	public void setTotalProcessingTime(long totalProcessingTime) {
		this.totalProcessingTime = totalProcessingTime;
	}

	public double getTotalProcessingTimeRequest() {
		return totalProcessingTimeRequest;
	}

	public void setTotalProcessingTimeRequest(double totalProcessingTimeRequest) {
		this.totalProcessingTimeRequest = totalProcessingTimeRequest;
	}

	private long averageProcessingTime;

    private double averageProcessingTimeRequest;

    private long totalProcessingTime;

    private double totalProcessingTimeRequest;
    /**
     * Default output header.
     */
    private final String header = "cacheSize;poolSize;minPoolSize;maxCacheSize;sessionTimeOut";
    /**
     * Header extension for execution monitoring. These data have Long type !!!
     */
    /**
     * averageProcessingTime is in stand by till EasyBeans issue EZB-411 not fixed
    private final String headerExt = ";averageProcessingTime;averageProcessingTimeReq;totalProcessingTime;totalProcessingTimeReq;numberOfCalls;callsRate";
     */
    private final String headerExt = ";totalProcessingTime;totalProcessingTimeReq;numberOfCalls;callsRate";


}
