/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSData
extends SampleData {
    private static final String header = "servedRate;servedOpen;jdbcMaxConnPool;currentOpen;busyMax;waitersHighRecent;waitingHighRecent;meanWaitTime;rejectedOpen;connectionLeaks";

    @Override
    public void compute(SampleData needs_cast) throws Exception {
        DSData prev = (DSData)needs_cast;
        if (prev != null) {
            try {
                double sampleTime = this.computeSamplePeriod(prev);
                int deltaServedOpen = this.getAttributeAsInt("servedOpen") - prev.getAttributeAsInt("servedOpen");
                this.setAttribute(new Attribute("servedOpenRate", new Double((double)deltaServedOpen / sampleTime)));
                int deltaWaiterCount = this.getAttributeAsInt("waiterCount") - prev.getAttributeAsInt("waiterCount");
                long deltaWaitingTime = this.getAttributeAsLong("waitingTime") - prev.getAttributeAsLong("waitingTime");
                double meanWaitTime = deltaWaiterCount > 0 ? 1.0 * (double)deltaWaitingTime / (double)deltaWaiterCount : 0.0;
                this.setAttribute(new Attribute("meanWaitTime", new Double(meanWaitTime)));
            }
            catch (NullPointerException e) {
                throw new Exception("The polled MBean is not a Datasource");
            }
        } else {
            this.setAttribute(new Attribute("servedOpenRate", new Double(0.0)));
            this.setAttribute(new Attribute("meanWaitTime", new Double(0.0)));
        }
    }

    @Override
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", DSData.getSeparator());
    }

    @Override
    protected String getInnerPrintData() {
        return decimalFormat.format(this.getAttributeAsDouble("servedOpenRate")) + DSData.getSeparator() + this.getAttributeAsInt("servedOpen") + DSData.getSeparator() + this.getAttributeAsInt("jdbcMaxConnPool") + DSData.getSeparator() + this.getAttributeAsInt("currentOpened") + DSData.getSeparator() + this.getAttributeAsInt("busyMax") + DSData.getSeparator() + this.getAttributeAsInt("waitersHighRecent") + DSData.getSeparator() + this.getAttributeAsLong("waitingHighRecent") + DSData.getSeparator() + decimalFormat.format(this.getAttributeAsDouble("meanWaitTime")) + DSData.getSeparator() + this.getAttributeAsInt("rejectedOpen") + DSData.getSeparator() + this.getAttributeAsInt("connectionLeaks");
    }

    @Override
    public Map<String, ?> getValueOfAttributes() {
        HashMap<String, Number> valueOfAttributes = new HashMap<String, Number>();
        valueOfAttributes.put("servedRate", this.getAttributeAsDouble("servedOpenRate"));
        valueOfAttributes.put("servedOpen", this.getAttributeAsInt("servedOpen"));
        valueOfAttributes.put("jdbcMaxConnPool", this.getAttributeAsInt("jdbcMaxConnPool"));
        valueOfAttributes.put("currentOpen", this.getAttributeAsInt("currentOpened"));
        valueOfAttributes.put("busyMax", this.getAttributeAsInt("busyMax"));
        valueOfAttributes.put("waitersHighRecent", this.getAttributeAsInt("waitersHighRecent"));
        valueOfAttributes.put("waitingHighRecent", this.getAttributeAsLong("waitingHighRecent"));
        valueOfAttributes.put("meanWaitTime", this.getAttributeAsDouble("meanWaitTime"));
        valueOfAttributes.put("rejectedOpen", this.getAttributeAsInt("rejectedOpen"));
        valueOfAttributes.put("connectionLeaks", this.getAttributeAsInt("connectionLeaks"));
        return valueOfAttributes;
    }
}

