/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SessionBeanData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SessionBeanSampler;

public class SFBSampler
extends SessionBeanSampler {
    private static final String[] attIds = new String[]{"name", "cacheSize", "poolSize", "minPoolSize", "maxCacheSize", "sessionTimeOut"};

    public SFBSampler(SamplerContext context) {
        super(context);
    }

    public String getDefaultOnPattern() {
        return "*:j2eeType=StatefulSessionBean,*";
    }

    protected void pollSessionBean(ObjectName on, SessionBeanData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        try {
            cnx = this.getMBeanServerConnection();
            al = cnx.getAttributes(on, attIds);
            this.releaseMbeanServerConnection();
            cnx = null;
            for (Attribute att : al) {
                data.setAttribute(att);
            }
            data.setServerInfo(this.getName(), this.getJmxUrl(), this.getServer(), this.getDomain());
            data.setCmdId(this.getCmdId());
            data.setValid(true);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace(System.err);
        }
        catch (ReflectionException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

