/**
 * JASMINe
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */

package org.ow2.jasmine.monitoring.mbeancmd.audit;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;

import javax.management.Attribute;

/**
 * @author waeselyf
 * 
 * Provides for metric comparison. useful for Tree ordering
 */
public class MetricComparator implements Comparator<Metric> {

    /*
    public static void main(String[] args) throws MalformedObjectNameException, NullPointerException {

        Attribute a1 = new Attribute("toto", null);
        AttributeList l1 = new AttributeList();
        l1.add(a1);
        Metric m1 = new Metric(1L, "ici", ObjectName.getInstance("x:type=y"), l1);
        a1 = new Attribute("toto", new Double(12));
        AttributeList l2 = new AttributeList();
        l2.add(a1);
        Metric m2 = new Metric(11L, "la", ObjectName.getInstance("x:type=y"), l2);
        MetricComparator comp = new MetricComparator("toto", 1);
        int ret = comp.compare(m1, m2);
        System.out.println(ret);
    }
    */

    /**
     * Constructor 
     * @param attr :
     *            the attribute used to compare both metrics
     */
    public MetricComparator(String attr, int mode) {
        this.attribute = attr;
        this.mode = mode;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
     */
    public int compare(Metric m1, Metric m2) {

        int ret = Integer.MIN_VALUE;
        if (m1 == null) {
            if (m2 != null) {
                ret = Integer.MIN_VALUE;
            } else {
                ret = 0;
            }
        } else if (m2 == null) {
            ret = Integer.MAX_VALUE;
        } else {
            Attribute a1 = m1.getAttribute(attribute);
            Attribute a2 = m2.getAttribute(attribute);
            if (a1 == null) {
                if (a2 != null) {
                    ret = Integer.MIN_VALUE;
                } else {
                    ret = 0;
                }
            } else if (a2 == null) {
                ret = Integer.MAX_VALUE;
            } else {
                Object v1 = a1.getValue();
                Object v2 = a2.getValue();
                if (isValid(v1) && isValid(v2)) {

                    if (v1 == null) {
                        if (v2 == null) {
                            ret = 0;
                        } else {
                            ret = Integer.MIN_VALUE;
                        }
                    } else if (v2 == null) {
                        ret = Integer.MAX_VALUE;
                    } else {
                        Method meth;

                        try {
                            // order by attribute value
                            meth = v1.getClass().getDeclaredMethod("compareTo", new Class[] { v1.getClass() });
                            ret = ((Integer) meth.invoke(v1, new Object[] { v2 })).intValue();

                            // if attribute values are equal, order by source
                            if (ret == 0) {
                                ret = m1.getSource().compareTo(m2.getSource());
                            }

                            // if both (value,source) are equal, order by mbean
                            // name
                            if (ret == 0) {
                                ret = m1.getName().toString().compareTo(m2.getName().toString());
                            }

                        } catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
            }
        }
        return ret * mode;
    }

    private static boolean isValid(Object obj) {
        return (obj == null) || obj.getClass().isPrimitive() || types.containsKey(obj.getClass());
    }

    /**
     * Constant for requesting an ascending order
     */
    public static final int ASCENDING_ORDER = 1;

    /**
     * Constant for requesting an descending order
     */
    public static final int DESCENDING_ORDER = -1;

    private String attribute = null;

    private int mode = DESCENDING_ORDER;

    private static final HashMap types = new HashMap();
    static {
        types.put(Integer.class, Integer.class);
        types.put(Long.class, Long.class);
        types.put(Float.class, Float.class);
        types.put(Double.class, Double.class);
        types.put(String.class, String.class);
        types.put(Boolean.class, Boolean.class);
    }
}
