/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: StatMBeanResult.java 9316 2011-11-18 16:00:17Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import javax.management.AttributeList;
import javax.management.ObjectName;

/**
 * FTO. Data structure containing the polled Attributes for each MBean.
 * @author danesa
 */
public class StatMBeanResult {
    String alias = null;
    ObjectName on = null;
    AttributeList attl = null;

    public StatMBeanResult(final String alias, final ObjectName on, final AttributeList attl) {
        this.alias = alias;
        this.attl = attl;
        this.on = on;
    }

    public String getAlias() {
        return alias;
    }

    public ObjectName getOn() {
        return on;
    }

    public AttributeList getAttl() {
        return attl;
    }
}
