/**
 * JASMINe
 * Copyright (C) 2005-2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SLBSampler.java 8156 2011-05-13 15:40:30Z jlegrand $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.IOException;
import java.util.Iterator;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;

/**
 * Sampler for retrieving data from stateless session beans.
 */
public class SLBSampler extends SessionBeanSampler {
    /**
     * Implementation of inherited method.
     *
     * @see Sampler#Sampler(String)
     */
    public SLBSampler(final SamplerContext context) {
        super(context);
    }

    /**
     * Implementation of inherited abstract method.
     *
     * @see Sampler#getDefaultOn()
     */
    public String getDefaultOnPattern() {
        return "*:j2eeType=StatelessSessionBean,*";
    }

    /**
     * Polls one stateless bean provider for data.
     *
     * @param on    Name of the provider.
     * @param data  SLBData to add polled information to.
     */
    protected void pollSessionBean(final ObjectName on, final SessionBeanData data) {
        AttributeList al = null;
        AttributeList alExt = null; // attribute list extension
        MBeanServerConnection cnx = null;
        Attribute att;
        try {
            cnx = getMBeanServerConnection();
            al = cnx.getAttributes(on, attIds);
            alExt = cnx.getAttributes(on, extAttIds);
            releaseMbeanServerConnection();
            cnx = null;
            Iterator it = al.iterator();
            while (it.hasNext()) {
                att = (Attribute) it.next();
                data.setAttribute(att);
            }
            // iterate over attributes extension
            if (it.hasNext()) {
                att = (Attribute) it.next();
                // totalProcessingTime
                if (att.getValue() != null) {
                    long totalProcessingTime = ((Long) att.getValue()).longValue();
                    data.setAverageProcessingTime(totalProcessingTime);
                }
            }
            if (it.hasNext()) {
                att = (Attribute) it.next();
                // numberOfCalls
                if (att.getValue() != null) {
                    long numberOfCalls = ((Long) att.getValue()).longValue();
                    data.setAverageProcessingTime(numberOfCalls);
                }
            }
            data.setServerInfo(getName(), getJmxUrl(), getServer(), getDomain());
            data.setCmdId(getCmdId());
            data.setValid(true);
        } catch (InstanceNotFoundException e) {
            e.printStackTrace(System.err);
        } catch (ReflectionException e) {
            e.printStackTrace(System.err);
        } catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    /**
     * Polled attribute identifiers.
     */
    private static final String[] attIds = {
             "name",
             "cacheSize",
             "poolSize",
             "minPoolSize",
             "maxCacheSize",
             "sessionTimeOut"
    };
    /**
     * Extension: execution monitoring attributes identifiers.
     */
    private static final String[] extAttIds = {
             //"averageProcessingTime",
             "totalProcessingTime",
             "numberOfCalls"
    };

}
