/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.jasmine;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mule.extras.client.MuleClient;
import org.mule.umo.UMOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleDispatcher
implements Runnable {
    private String version = "v1";
    private BufferedReader reader;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, List<Integer>> indexes = new HashMap<String, List<Integer>>();
    private int nbBaseHeaderElements = 7;
    private String jasmineURI;

    public MuleDispatcher(BufferedReader reader, String jasmineURI) {
        this.reader = reader;
        this.jasmineURI = jasmineURI;
    }

    @Override
    public void run() {
        try {
            String alias;
            int index;
            String headerElement;
            int i;
            MuleClient client = null;
            while (client == null) {
                Thread.sleep(1000L);
                client = new MuleClient();
            }
            String uniqueHeader = this.reader.readLine();
            if (uniqueHeader == null) {
                System.err.println("Nothing to send: stop MuleDispatcher");
                return;
            }
            String[] msgHeader = uniqueHeader.split(";");
            String baseHeader = "";
            for (int i2 = 0; i2 < this.nbBaseHeaderElements; ++i2) {
                baseHeader = baseHeader + msgHeader[i2] + ";";
            }
            boolean aliases = true;
            for (i = 0; i < msgHeader.length; ++i) {
                headerElement = msgHeader[i];
                if (i <= this.nbBaseHeaderElements - 1) continue;
                index = headerElement.indexOf(":");
                if (index == -1) {
                    aliases = false;
                    break;
                }
                alias = headerElement.substring(0, index);
                if (!this.indexes.containsKey(alias)) {
                    ArrayList indexList = new ArrayList();
                    this.indexes.put(alias, indexList);
                }
                this.indexes.get(alias).add(i);
            }
            if (aliases) {
                for (i = 0; i < msgHeader.length; ++i) {
                    headerElement = msgHeader[i];
                    if (i <= this.nbBaseHeaderElements - 1) continue;
                    index = headerElement.indexOf(":");
                    alias = headerElement.substring(0, index);
                    String attName = headerElement.substring(index + 1, headerElement.length());
                    if (!this.headers.containsKey(alias)) {
                        this.headers.put(alias, baseHeader);
                    }
                    String currentHeader = this.headers.get(alias);
                    currentHeader = i == msgHeader.length - 1 ? currentHeader + attName : currentHeader + attName + ";";
                    this.headers.put(alias, currentHeader);
                }
                for (String alias2 : this.headers.keySet()) {
                    System.out.println(alias2 + " header: " + this.headers.get(alias2));
                }
            }
            String header = "mbeancmd_values_" + this.version + "\n" + uniqueHeader + "\n";
            while (true) {
                if (this.reader.ready()) {
                    String nextLine = this.reader.readLine();
                    String msg = null;
                    if (!aliases) {
                        msg = header + nextLine;
                    } else {
                        String[] msgElements = nextLine.split(";");
                        for (String alias3 : this.indexes.keySet()) {
                            List<Integer> indexList = this.indexes.get(alias3);
                            String firstElement = msgElements[indexList.get(0)];
                            if (firstElement.length() <= 0) continue;
                            String fixedLine = this.fixLine(msgElements, indexList);
                            msg = "mbeancmd_values_" + this.version + "\n" + this.headers.get(alias3) + "\n" + fixedLine;
                            break;
                        }
                    }
                    try {
                        client.dispatch(this.jasmineURI, (Object)msg, null);
                    }
                    catch (NullPointerException e) {
                        Logger.getLogger(MuleDispatcher.class.getName()).log(Level.INFO, "Mule stopped ... Message is not delivered anymore to " + this.jasmineURI);
                        break;
                    }
                }
                Thread.sleep(900L);
            }
        }
        catch (UMOException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String fixLine(String[] msgElements, List<Integer> indexList) {
        String newLine = "";
        int nbElements = 7;
        for (int i = 0; i < nbElements; ++i) {
            newLine = newLine + msgElements[i] + ";";
        }
        for (int index : indexList) {
            newLine = newLine + msgElements[index] + ";";
        }
        newLine = newLine.substring(0, newLine.length() - 1);
        return newLine;
    }
}

