/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DiskFree.java 8094 2011-04-29 14:55:16Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.StringTokenizer;

/**
 * Give the disk free space in % for a given disk
 * This command does not use Lewys, but the df command.
 * It works only on linux.
 */
public class DiskFree extends Lewys {

    String diskName;

    /**
     * Tests the command.
     * @param args Arguments to pass to command
     */
    public static void main(final String[] args) {
        Lewys p = new Network();
        p.setArgs("diskfree", args);
        p.exec(null);
    }

    @Override
    protected void lewysPoll() {
        boolean goOn = true;
        while (goOn) {
            try {
                long t = System.currentTimeMillis();
                printResult(t, getDiskUsage());
            } catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            // Sleep for the time of the period
            try {
                Thread.sleep(period * 1000);
            } catch (InterruptedException e) {
                goOn = false;
            }
        }
    }

    @Override
    protected void configProbe() {
        diskName = (String) arg_probe_config.get(0);
    }

    private String getMBeanPollHeader() {
        if (header == null) {
            StringBuffer buf = new StringBuffer(512);
            buf.append("date");
            buf.append(separator);
            buf.append("time");
            buf.append(separator);
            buf.append("sname");
            buf.append(separator);
            buf.append("server");
            buf.append(separator);
            buf.append("domain");
            buf.append(separator);
            buf.append("mbean");
            buf.append(separator);
            buf.append("use");
            header = buf.toString();
        }
        return header;
    }

    private void printResult(long t, int result) {
        if (header == null) {
            pout.println(getMBeanPollHeader());
        }

        Date d = new Date(t);
        pout.print(SIMPLEDATEFORMAT.format(d));
        pout.print(separator);
        pout.print(t);
        pout.print(separator);
        pout.print("na");
        pout.print(separator);
        pout.print(serverName);
        pout.print(separator);
        pout.print(domainName);
        pout.print(separator);
        pout.print("disk.use:/dev/"+diskName);
        pout.print(separator);
        pout.print(result);
        pout.println();
    }

    private int getDiskUsage() throws IOException, InterruptedException {
        String cmd = "df -l /dev/" + diskName;
        Runtime run = Runtime.getRuntime();
        Process pr = run.exec(cmd);
        pr.waitFor();
        BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        buf.readLine(); // skip header
        String line = buf.readLine();
        StringTokenizer stk = new StringTokenizer(line);
        String struse = "";
        while (stk.hasMoreTokens()) {
            String tok = stk.nextToken();
            int len = tok.length();
            if (tok.endsWith("%") && len > 1) {
                 struse = tok.substring(0, len - 1);
            }
        }
        return new Integer(struse);
    }
}