/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.util.Date;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.probe.linux.Linux2_6DiskProbe;
import org.objectweb.lewys.probe.windows.DiskProbe;
import org.ow2.jasmine.monitoring.mbeancmd.commands.Lewys;
import org.ow2.jasmine.monitoring.mbeancmd.commands.Network;

public class Disk
extends Lewys {
    protected int[] resourceIds = new int[4];

    public static void main(String[] args) {
        Network p = new Network();
        p.setArgs("disk", args);
        p.exec(null);
    }

    protected void configProbe() {
        try {
            switch (this.osType) {
                case 10: {
                    this.probe = new org.objectweb.lewys.probe.linux.DiskProbe();
                    break;
                }
                case 11: {
                    this.probe = new Linux2_6DiskProbe();
                    break;
                }
                case 20: {
                    this.probe = new DiskProbe();
                    break;
                }
                case 30: {
                    this.probe = new org.objectweb.lewys.probe.macosx.DiskProbe();
                    break;
                }
                default: {
                    throw new RuntimeException("No DiskProbe available for " + System.getProperty("os.name"));
                }
            }
        }
        catch (NoResourceToProbeException ex) {
            throw new RuntimeException("Can't set Disk probe", ex);
        }
        String diskName = (String)this.arg_probe_config.get(0);
        try {
            this.resourceIds[0] = this.probe.getResourceId(diskName + " write sectors");
            this.resourceIds[1] = this.probe.getResourceId(diskName + " read sectors");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get Disk Info for " + diskName + " : " + e);
        }
    }

    protected void lewysPoll() {
        boolean goOn = true;
        long[] previousValues = null;
        while (goOn) {
            try {
                long[] values = this.probe.getValue(this.resourceIds);
                if (previousValues == null) {
                    previousValues = values;
                } else {
                    long[] result = new long[values.length];
                    result[0] = values[0] - previousValues[0];
                    result[1] = values[1] - previousValues[1];
                    long t = System.currentTimeMillis();
                    this.printResult(t, result);
                    previousValues = values;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            try {
                Thread.sleep(this.period * 1000L);
            }
            catch (InterruptedException e) {
                goOn = false;
            }
        }
    }

    private String getMBeanPollHeader() {
        if (this.header == null) {
            StringBuffer buf = new StringBuffer(512);
            buf.append("date");
            buf.append(this.separator);
            buf.append("time");
            buf.append(this.separator);
            buf.append("sname");
            buf.append(this.separator);
            buf.append("server");
            buf.append(this.separator);
            buf.append("domain");
            buf.append(this.separator);
            buf.append("mbean");
            buf.append(this.separator);
            buf.append("sectors written");
            buf.append(this.separator);
            buf.append("sectors read");
            this.header = buf.toString();
        }
        return this.header;
    }

    private void printResult(long t, long[] result) {
        if (this.header == null) {
            this.pout.println(this.getMBeanPollHeader());
        }
        Date d = new Date(t);
        this.pout.print(SIMPLEDATEFORMAT.format(d));
        this.pout.print(this.separator);
        this.pout.print(t);
        this.pout.print(this.separator);
        this.pout.print("na");
        this.pout.print(this.separator);
        this.pout.print(this.serverName);
        this.pout.print(this.separator);
        this.pout.print(this.domainName);
        this.pout.print(this.separator);
        this.pout.print("disk");
        this.pout.print(this.separator);
        this.pout.print(result[0]);
        this.pout.print(this.separator);
        this.pout.print(result[1]);
        this.pout.println();
    }
}

