/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.File;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import javax.management.MalformedObjectNameException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.objectweb.lewys.probe.Probe;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.graph.Grapher;
import org.ow2.jasmine.monitoring.mbeancmd.jasmine.JasmineConnector;

public abstract class Lewys
extends AbstractCommand {
    protected int osType;
    protected static final int LINUX_2_4 = 10;
    protected static final int LINUX_2_6 = 11;
    protected static final int WINDOWS = 20;
    protected static final int MAC_OS_X = 30;
    protected Options options = null;
    protected CommandLine commandLine = null;
    protected List arg_probe_config;
    protected long period = 10L;
    protected String graphDef = null;
    protected String outputFilePath = null;
    protected String jasmineURI = null;
    protected String separator = ";";
    protected Object serverName;
    protected Object domainName;
    protected Probe probe;
    protected PrintStream pout = null;
    protected String header = null;

    public Lewys() {
        this.setOptions();
    }

    public int exec(CommandDispatcher cmdDispatcher) {
        if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
            this.osType = System.getProperty("os.version").startsWith("2.6") ? 11 : 10;
        } else if (System.getProperty("os.name").startsWith("Windows")) {
            this.osType = 20;
        } else if (System.getProperty("os.name").equals("Mac OS X")) {
            this.osType = 30;
        }
        try {
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        PipedOutputStream out = new PipedOutputStream();
        this.pout = new PrintStream(out);
        Outer outer = null;
        try {
            if (this.outputFilePath != null) {
                outer = new Outer(out, new File(this.outputFilePath));
            } else if (this.jasmineURI == null) {
                outer = new Outer(out, System.out);
            }
            if (this.jasmineURI != null) {
                if (outer == null) {
                    outer = JasmineConnector.connect((PipedOutputStream)out, (String)this.jasmineURI);
                } else {
                    Outer oldOuter = outer;
                    outer = JasmineConnector.connect((Outer)outer, (String)this.jasmineURI);
                    new Thread((Runnable)oldOuter).start();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.graphDef != null) {
            try {
                PipedOutputStream sink = new PipedOutputStream();
                outer.setSink(sink);
                Grapher gr = new Grapher(sink, this.graphDef);
                gr.start();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        new Thread((Runnable)outer).start();
        this.configProbe();
        this.lewysPoll();
        return 0;
    }

    public String summary() {
        return "Periodically probes with LeWYS.";
    }

    protected abstract void configProbe();

    protected abstract void lewysPoll();

    protected void parseCommandLine(String[] args) throws ParseException, MalformedObjectNameException {
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        this.arg_probe_config = Arrays.asList(this.commandLine.getOptionValues("a"));
        if (this.arg_probe_config.isEmpty()) {
            throw new RuntimeException("Empty list of args");
        }
        if (this.commandLine.hasOption("p")) {
            this.period = Long.parseLong(this.commandLine.getOptionValue("p"));
        }
        if (this.commandLine.hasOption("graph")) {
            this.graphDef = this.commandLine.getOptionValue("graph");
        }
        if (this.commandLine.hasOption("f")) {
            this.outputFilePath = this.commandLine.getOptionValue("f");
        }
        if (this.commandLine.hasOption("jasmine")) {
            this.jasmineURI = this.commandLine.getOptionValue("jasmine");
        }
        if (this.commandLine.hasOption("s")) {
            this.separator = this.commandLine.getOptionValue("s");
            Outer.setSeparator((String)this.separator);
        }
        if (this.commandLine.hasOption("n")) {
            this.serverName = this.commandLine.getOptionValue("n");
        }
        if (this.commandLine.hasOption("d")) {
            this.domainName = this.commandLine.getOptionValue("d");
        }
    }

    protected void setOptions() {
        this.options = new Options();
        this.options.addOption("v", "verbose", false, "Verbose mode");
        Option atts = new Option("a", "atts", true, "attributes to poll");
        atts.setRequired(false);
        atts.setOptionalArg(true);
        atts.setArgs(-2);
        atts.setArgName("attributes");
        this.options.addOption(atts);
        Option period = new Option("p", "period", true, "Polling period");
        atts.setRequired(false);
        period.setArgName("period");
        period.setArgs(1);
        this.options.addOption(period);
        Option graph = new Option("graph", "graph", true, "Enable graphical output");
        graph.setRequired(false);
        graph.setArgName("graphDefinition");
        graph.setArgs(1);
        this.options.addOption(graph);
        Option file = new Option("f", "file", true, "Send output to file instead of stdout");
        file.setRequired(false);
        file.setArgName("path");
        file.setArgs(1);
        this.options.addOption(file);
        Option jasmine = new Option("jasmine", "jasmine", true, "Output logged data to jasmine (will disable stdout)");
        jasmine.setRequired(false);
        jasmine.setArgName("jasmineURI");
        jasmine.setArgs(1);
        this.options.addOption(jasmine);
        Option separator = new Option("s", "separator", true, "Set the column separator");
        separator.setRequired(false);
        separator.setArgName("separator");
        separator.setArgs(1);
        this.options.addOption(separator);
        Option server = new Option("n", "name", true, "Server name");
        server.setRequired(false);
        server.setArgName("serverName");
        server.setArgs(1);
        this.options.addOption(server);
        Option domain = new Option("d", "domain", true, "Domain name");
        domain.setRequired(false);
        domain.setArgName("domainName");
        domain.setArgs(1);
        this.options.addOption(domain);
    }
}

