/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.util.Date;
import org.objectweb.lewys.common.exceptions.NoResourceToProbeException;
import org.objectweb.lewys.probe.windows.NetworkProbe;
import org.ow2.jasmine.monitoring.mbeancmd.commands.Lewys;

public class Network
extends Lewys {
    protected int[] resourceIds = new int[4];

    public static void main(String[] args) {
        Network p = new Network();
        p.setArgs("network", args);
        p.exec(null);
    }

    protected void configProbe() {
        try {
            switch (this.osType) {
                case 10: 
                case 11: {
                    this.probe = new org.objectweb.lewys.probe.linux.NetworkProbe();
                    break;
                }
                case 20: {
                    this.probe = new NetworkProbe();
                    break;
                }
                case 30: {
                    this.probe = new org.objectweb.lewys.probe.macosx.NetworkProbe();
                    break;
                }
                default: {
                    throw new RuntimeException("No Network probe available for " + System.getProperty("os.name"));
                }
            }
        }
        catch (NoResourceToProbeException ex) {
            throw new RuntimeException("Can't set Network probe", ex);
        }
        String networkcardName = (String)this.arg_probe_config.get(0);
        try {
            this.resourceIds[0] = this.probe.getResourceId(networkcardName + " bytes received");
            this.resourceIds[1] = this.probe.getResourceId(networkcardName + " packets received");
            this.resourceIds[2] = this.probe.getResourceId(networkcardName + " bytes transmit");
            this.resourceIds[3] = this.probe.getResourceId(networkcardName + " packets transmit");
        }
        catch (Exception e) {
            throw new RuntimeException(this.errorMessage());
        }
    }

    protected void lewysPoll() {
        boolean goOn = true;
        long[] previousValues = null;
        while (goOn) {
            try {
                long[] values = this.probe.getValue(this.resourceIds);
                if (previousValues == null) {
                    previousValues = values;
                } else {
                    long[] result = new long[values.length];
                    result[0] = (values[0] - previousValues[0]) / 1000L;
                    result[1] = values[1] - previousValues[1];
                    result[2] = (values[2] - previousValues[2]) / 1000L;
                    result[3] = values[3] - previousValues[3];
                    long t = System.currentTimeMillis();
                    this.printResult(t, result);
                    previousValues = values;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            try {
                Thread.sleep(this.period * 1000L);
            }
            catch (InterruptedException e) {
                goOn = false;
            }
        }
    }

    private String getMBeanPollHeader() {
        if (this.header == null) {
            StringBuffer buf = new StringBuffer(512);
            buf.append("date");
            buf.append(this.separator);
            buf.append("time");
            buf.append(this.separator);
            buf.append("sname");
            buf.append(this.separator);
            buf.append("server");
            buf.append(this.separator);
            buf.append("domain");
            buf.append(this.separator);
            buf.append("mbean");
            buf.append(this.separator);
            buf.append("KbytesReceived");
            buf.append(this.separator);
            buf.append("packetsReceived");
            buf.append(this.separator);
            buf.append("KbytesTransmit");
            buf.append(this.separator);
            buf.append("packetsTransmit");
            this.header = buf.toString();
        }
        return this.header;
    }

    private void printResult(long t, long[] result) {
        if (this.header == null) {
            this.pout.println(this.getMBeanPollHeader());
        }
        Date d = new Date(t);
        this.pout.print(SIMPLEDATEFORMAT.format(d));
        this.pout.print(this.separator);
        this.pout.print(t);
        this.pout.print(this.separator);
        this.pout.print("na");
        this.pout.print(this.separator);
        this.pout.print(this.serverName);
        this.pout.print(this.separator);
        this.pout.print(this.domainName);
        this.pout.print(this.separator);
        this.pout.print("network");
        this.pout.print(this.separator);
        this.pout.print(result[0]);
        this.pout.print(this.separator);
        this.pout.print(result[1]);
        this.pout.print(this.separator);
        this.pout.print(result[2]);
        this.pout.print(this.separator);
        this.pout.print(result[3]);
        this.pout.println();
    }

    private String errorMessage() {
        String[] resourceNames = this.probe.getResourceNames();
        String mess = "";
        mess = mess + "\n. Bad probe parameters: A correct Networkcard name must be provided in section BladeArgument [pollingPeriod pollingTime Networkcardname]!!\n.\n";
        mess = mess + ". Networkcard Names for this host are:\n";
        int totalNbResource = this.osType == 30 ? 17 : 16;
        for (int j = 0; j < resourceNames.length; j += totalNbResource) {
            String name = resourceNames[j].substring(0, resourceNames[j].length() - "bytes received".length());
            mess = mess + ". " + name + "\n";
        }
        mess = mess + ".\n. HINT: If a NetworkCardName is too long, provide only the last discriminating characters.\n";
        mess = mess + ". For Instance: \n\n.                  \"card1 3Gbits/s\"\n.                    in place of \n. \"My PowerFul NetworkCard FULL Duplex card1 3Gbits/s\" \n.\n. ATTENTION: The provided NetWorkCard Name must not comport character \";\" .\n";
        return mess;
    }
}

