/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.StringTokenizer;
import org.ow2.jasmine.monitoring.mbeancmd.commands.Lewys;

public class DiskFree
extends Lewys {
    String diskName;

    public static void main(String[] args) {
        DiskFree p = new DiskFree();
        p.setArgs("diskfree", args);
        p.exec(null);
    }

    protected void lewysPoll() {
        boolean goOn = true;
        while (goOn) {
            try {
                long t = System.currentTimeMillis();
                this.printResult(t, this.getDiskUsage());
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            try {
                Thread.sleep(this.period * 1000L);
            }
            catch (InterruptedException e) {
                goOn = false;
            }
        }
    }

    protected void configProbe() {
        this.diskName = (String)this.arg_probe_config.get(0);
    }

    private String getMBeanPollHeader() {
        if (this.header == null) {
            StringBuffer buf = new StringBuffer(512);
            buf.append("date");
            buf.append(this.separator);
            buf.append("time");
            buf.append(this.separator);
            buf.append("sname");
            buf.append(this.separator);
            buf.append("server");
            buf.append(this.separator);
            buf.append("domain");
            buf.append(this.separator);
            buf.append("mbean");
            buf.append(this.separator);
            buf.append("use");
            this.header = buf.toString();
        }
        return this.header;
    }

    private void printResult(long t, int result) {
        if (this.header == null) {
            this.pout.println(this.getMBeanPollHeader());
        }
        Date d = new Date(t);
        this.pout.print(SIMPLEDATEFORMAT.format(d));
        this.pout.print(this.separator);
        this.pout.print(t);
        this.pout.print(this.separator);
        this.pout.print("na");
        this.pout.print(this.separator);
        this.pout.print(this.serverName);
        this.pout.print(this.separator);
        this.pout.print(this.domainName);
        this.pout.print(this.separator);
        this.pout.print("disk.use:/dev/" + this.diskName);
        this.pout.print(this.separator);
        this.pout.print(result);
        this.pout.println();
    }

    private int getDiskUsage() throws IOException, InterruptedException {
        String cmd = "df -l /dev/" + this.diskName;
        Runtime run = Runtime.getRuntime();
        Process pr = run.exec(cmd);
        pr.waitFor();
        BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        buf.readLine();
        String line = buf.readLine();
        StringTokenizer stk = new StringTokenizer(line);
        String struse = "";
        while (stk.hasMoreTokens()) {
            String tok = stk.nextToken();
            int len = tok.length();
            if (!tok.endsWith("%") || len <= 1) continue;
            struse = tok.substring(0, len - 1);
        }
        return new Integer(struse);
    }
}

