/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.TreeMap;
import org.ow2.jasmine.monitoring.mbeancmd.Command;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandDispatcher {
    private static final String COMMAND_DEFINITIONS = "META-INF/mbeancmd/commands.defs";
    private TreeMap<String, String> commands = null;
    private boolean isEmbedded = true;
    private static boolean osgiEnabled = false;
    private static Log logger = LogFactory.getLog(CommandDispatcher.class);

    protected CommandDispatcher() {
    }

    public static void main(String[] args) {
        CommandDispatcher dispatcher = new CommandDispatcher();
        dispatcher.setEmbedded(false);
        dispatcher.init(args);
    }

    public static int start(String[] args) {
        CommandDispatcher dispatcher;
        if (CommandDispatcher.isOSGiEnabled()) {
            try {
                Class<?> klass = CommandDispatcher.class.getClassLoader().loadClass("org.ow2.jasmine.monitoring.mbeancmd.osgi.CommandDispatcher");
                dispatcher = (CommandDispatcher)klass.newInstance();
            }
            catch (Exception e) {
                logger.error((Object)"Unable to retrieve the OSGi Command Dispatcher", new Object[]{e});
                throw new RuntimeException("Unable to retrieve the OSGi Command Dispatcher", e);
            }
        } else {
            dispatcher = new CommandDispatcher();
        }
        return dispatcher.init(args);
    }

    public int init(String[] args) {
        String cmdName = null;
        Command cmd = null;
        String[] cmdArgs = null;
        if (this.commands == null) {
            this.findCommands();
        }
        if (args.length > 0) {
            cmdName = args[0];
            cmd = this.getCommand(cmdName);
        }
        if (cmd == null) {
            cmdName = "help";
            cmd = this.getCommand(cmdName);
        } else if (args.length > 1) {
            cmdArgs = new String[args.length - 1];
            System.arraycopy(args, 1, cmdArgs, 0, args.length - 1);
        }
        cmd.setArgs(cmdName, cmdArgs);
        return cmd.exec(this);
    }

    public Command getCommand(String name) {
        Command cmd = null;
        String cname = this.commands.get(name);
        if (cname != null) {
            try {
                Class<?> cl = this.loadClass(cname);
                cmd = (Command)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)"Error : {0}", new Object[]{e});
            }
            catch (InstantiationException e) {
                logger.warn((Object)"Error : {0}", new Object[]{e});
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)"Error : {0}", new Object[]{e});
            }
        }
        return cmd;
    }

    public String[] getAvailableCommands() {
        if (this.commands == null) {
            return null;
        }
        String[] cmds = new String[this.commands.size()];
        cmds = this.commands.keySet().toArray(cmds);
        return cmds;
    }

    private String getRadix(String fqn) {
        String radix = fqn.substring(fqn.lastIndexOf(".") + 1);
        return radix;
    }

    private void findCommands() {
        try {
            InputStreamReader in0 = this.getInputStreamReader(COMMAND_DEFINITIONS);
            if (in0 != null) {
                BufferedReader in = new BufferedReader(in0);
                String command = null;
                while ((command = in.readLine()) != null) {
                    if ("".equals(command) || command.indexOf("#") == 0) continue;
                    try {
                        Class<?> cl = this.loadClass(command);
                        if (!Command.class.isAssignableFrom(cl)) continue;
                        if (this.commands == null) {
                            this.commands = new TreeMap();
                        }
                        this.commands.put(this.getRadix(command).toLowerCase(), command);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("Cannot access META-INF/mbeancmd/commands.defs");
            e.printStackTrace();
        }
    }

    protected InputStreamReader getInputStreamReader(String name) throws IOException {
        return new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(name));
    }

    protected Class<?> loadClass(String cname) throws ClassNotFoundException {
        return Class.forName(cname);
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public void setEmbedded(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }

    protected static boolean isOSGiEnabled() {
        return osgiEnabled;
    }

    protected static void setOSGiEnabled(boolean osgiEnabled) {
        CommandDispatcher.osgiEnabled = osgiEnabled;
    }
}

