/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import org.objectweb.jonas.common.JProp;
import org.ow2.jasmine.adapter.jmx.pool.api.IJMXConnectionFactory;
import org.ow2.jasmine.adapter.jmx.pool.api.IJMXConnectionServer;
import org.ow2.jasmine.adapter.jmx.pool.api.JMXConnectionParam;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxCnxWrapper;

public class JmxAP {
    private static Context ctx = null;
    private CommandDispatcher cmdDispatcher = null;
    private MBeanServerConnection jmxConnection = null;
    private IJMXConnectionServer jmxConnectionEmbedded = null;
    private String jmxUrl = "service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas";
    private static Map<String, String> jmxTargets = new TreeMap<String, String>();
    private static Map<String, String> jmxUsers = new TreeMap<String, String>();
    private static Map<String, String> jmxPasswords = new TreeMap<String, String>();
    private static String defaultTarget = null;
    public static final String DEFAULT_URL = "service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas";
    public static final String DEFAULT_FILE = "jmxurls.properties";
    private IJMXConnectionFactory jmxFactory = null;

    public JmxAP(String jmxUrl, CommandDispatcher cmdDispatcher) {
        this.jmxUrl = jmxUrl;
        if (cmdDispatcher != null) {
            this.cmdDispatcher = cmdDispatcher;
            if (this.cmdDispatcher.isEmbedded()) {
                this.connectJMX();
            }
        }
    }

    public JmxAP(CommandDispatcher cmdDispatcher) {
        this(jmxTargets.get(defaultTarget), cmdDispatcher);
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    private void connectJMX() {
        Logger.getLogger(JmxAP.class.getName()).log(Level.FINE, "Connecting to the jmxFactory ...");
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            Logger.getLogger(JmxAP.class.getName()).log(Level.SEVERE, "Error while creating initialContext ...", e);
        }
        String lookup = this.jmxUrl.replaceAll(":|/", "_");
        try {
            this.jmxFactory = (IJMXConnectionFactory)ctx.lookup(lookup);
        }
        catch (NamingException e) {
            Logger.getLogger(JmxAP.class.getName()).log(Level.SEVERE, "Error while doing lookup for " + lookup, e);
        }
    }

    public MBeanServerConnection getMBeanServerConnection() {
        Logger.getLogger(JmxAP.class.getName()).log(Level.FINE, "getting MBeanserverConnection");
        if (this.jmxConnection == null) {
            if (this.cmdDispatcher != null && this.cmdDispatcher.isEmbedded() && this.jmxFactory != null) {
                try {
                    Logger.getLogger(JmxAP.class.getName()).log(Level.FINE, "getting MBeanserverConnection using the pool");
                    this.jmxConnectionEmbedded = (IJMXConnectionServer)this.jmxFactory.getConnection((ConnectionSpec)new JMXConnectionParam(this.jmxUrl, jmxUsers.get(this.jmxUrl), jmxPasswords.get(this.jmxUrl)));
                    this.jmxConnection = this.jmxConnectionEmbedded;
                }
                catch (ResourceException e) {
                    Logger.getLogger(JmxAP.class.getName()).log(Level.SEVERE, "Error while getting a connection ...");
                }
            } else {
                Logger.getLogger(JmxAP.class.getName()).log(Level.INFO, "Creating a simple JMX Connection without using the pool");
                this.jmxConnection = new JmxCnxWrapper(this.jmxUrl, jmxUsers.get(this.jmxUrl), jmxPasswords.get(this.jmxUrl));
            }
        }
        return this.jmxConnection;
    }

    public void releaseMBeanServerConnection() {
        if (this.cmdDispatcher != null && this.cmdDispatcher.isEmbedded() && this.jmxFactory != null) {
            this.jmxConnectionEmbedded.release();
            this.jmxConnection = null;
        }
    }

    public void closeMBeanServerConnection() {
        if (this.cmdDispatcher != null && this.cmdDispatcher.isEmbedded() && this.jmxFactory != null) {
            try {
                this.jmxConnectionEmbedded.close();
                this.jmxConnectionEmbedded = null;
            }
            catch (ResourceException e) {
                e.printStackTrace();
            }
        }
    }

    private static Properties getProperties(File propertyFile) throws IOException {
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream(propertyFile);
        properties.load(in);
        in.close();
        return properties;
    }

    public static String getJmxUrl(String name) {
        if (name == null) {
            return jmxTargets.get(defaultTarget);
        }
        if (name.startsWith("service:jmx:rmi")) {
            return name;
        }
        return jmxTargets.get(name);
    }

    public static String[] getJmxTargets() {
        String[] targets = null;
        if (!jmxTargets.isEmpty()) {
            targets = new String[jmxTargets.size()];
            targets = jmxTargets.keySet().toArray(targets);
        }
        return targets;
    }

    public static String[] getJmxTargets(String[] proposed) {
        int i;
        boolean all = false;
        String[] targetsArray = null;
        LinkedList<String> targetsList = new LinkedList<String>();
        if (proposed != null) {
            for (i = 0; i < proposed.length; ++i) {
                if ("all".equalsIgnoreCase(proposed[i])) {
                    all = true;
                    break;
                }
                String url = JmxAP.getJmxUrl(proposed[i]);
                if (url == null) continue;
                targetsList.add(proposed[i]);
            }
        } else if (defaultTarget != null) {
            targetsList.add(defaultTarget);
        }
        if (all) {
            targetsArray = JmxAP.getJmxTargets();
        } else if (targetsList.size() > 0) {
            targetsArray = new String[targetsList.size()];
            for (i = 0; i < targetsList.size(); ++i) {
                targetsArray[i] = (String)targetsList.get(i);
            }
        }
        return targetsArray;
    }

    public static String getDefaultTarget() {
        return defaultTarget;
    }

    private static void load() {
        String dftTarget = null;
        String url = System.getProperty("jasmine.jmx.url");
        String user = System.getProperty("jasmine.jmx.user");
        String password = System.getProperty("jasmine.jmx.password");
        String filename = System.getProperty("jasmine.jmx.file");
        if (filename == null) {
            filename = DEFAULT_FILE;
        }
        String name = null;
        if (url != null) {
            name = "jonas";
            if (url.matches(".*connector_.*")) {
                int ix = url.lastIndexOf("connector_");
                name = url.substring(ix + "connector_".length());
            }
            jmxTargets.put(name, url);
            if (user != null && password != null) {
                jmxUsers.put(url, user);
                jmxPasswords.put(url, password);
            }
            defaultTarget = name;
        }
        Properties props = null;
        try {
            props = JmxAP.getProperties(new File(filename));
        }
        catch (IOException e) {
            try {
                Class.forName("org.ow2.jonas.lib.bootstrap.JProp");
                props = JmxAP.getProperties(new File(org.ow2.jonas.lib.bootstrap.JProp.getConfDir(), filename));
                Logger.getLogger(JmxAP.class.getName()).log(Level.FINE, "class loaded : org.ow2.jonas.lib.bootstrap.JProp");
            }
            catch (Exception e3) {
                try {
                    Class.forName("org.objectweb.jonas.common.JProp");
                    props = JmxAP.getProperties(new File(JProp.getConfDir(), filename));
                    Logger.getLogger(JmxAP.class.getName()).log(Level.FINE, "class loaded : org.objectweb.jonas.common.JProp");
                }
                catch (Exception e1) {
                    System.err.println("WARNING : cannot read default JMX configuration file : " + e);
                }
            }
        }
        if (props != null && props.size() != 0) {
            String key;
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                key = (String)en.nextElement();
                if (!key.startsWith("jasmine.jmx.url.")) continue;
                name = key.substring("jasmine.jmx.url.".length());
                url = props.getProperty(key);
                jmxTargets.put(name, url);
            }
            en = props.propertyNames();
            while (en.hasMoreElements()) {
                key = (String)en.nextElement();
                if (key.startsWith("jasmine.jmx.user.")) {
                    name = key.substring("jasmine.jmx.user.".length());
                    url = jmxTargets.get(name);
                    if (url == null) {
                        System.err.println("WARNING : cannot set user for server : " + name);
                        continue;
                    }
                    jmxUsers.put(url, props.getProperty(key));
                    continue;
                }
                if (key.startsWith("jasmine.jmx.password.")) {
                    name = key.substring("jasmine.jmx.password.".length());
                    url = jmxTargets.get(name);
                    if (url == null) {
                        System.err.println("WARNING : cannot set password for server : " + name);
                        continue;
                    }
                    jmxPasswords.put(url, props.getProperty(key));
                    continue;
                }
                if (!"jasmine.jmx.default.target".equals(key) || defaultTarget != null) continue;
                dftTarget = props.getProperty(key);
            }
        }
        if (defaultTarget == null) {
            if (dftTarget != null) {
                if (jmxTargets.get(dftTarget) != null) {
                    defaultTarget = dftTarget;
                } else {
                    System.err.println("WARNING : jasmine.jmx.default.target specifies an invalid default target " + dftTarget + ". No default target.");
                }
            } else {
                defaultTarget = "jonas";
                jmxTargets.put(defaultTarget, DEFAULT_URL);
                System.err.println("WARNING : jasmine.jmx.default.target not specified => adding the default jmxUrl : " + defaultTarget + " jmxUrl=" + DEFAULT_URL);
            }
        }
    }

    static {
        JmxAP.load();
    }
}

