/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAP;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.graph.Grapher;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.Configurator;
import org.ow2.jasmine.monitoring.mbeancmd.jasmine.JasmineConnector;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XServerSampler;

public class Poll
extends AbstractCommand {
    private Options options = null;
    private CommandLine commandLine = null;
    private long period = 10L;
    private boolean isHttpOption = false;
    private boolean isServerOption = false;
    private boolean isTxOption = false;
    private boolean isCpuSunOption = false;
    private boolean isDataSourceOption = false;
    private boolean isJCACFSourceOption = false;
    private boolean isJoramQueueOption = false;
    private boolean isServletOption = false;
    private boolean isStatelessOption = false;
    private boolean isStatefulOption = false;
    private boolean isEntityOption = false;
    private String graphDef = null;
    private String outputFilePath = null;
    private String jasmineURI = null;
    private boolean isDtdOption = false;
    private String onPattern = null;
    private String separator = ";";

    public Poll() {
        this.setOptions();
    }

    public int exec(CommandDispatcher cmdDispatcher) {
        try {
            this.parseCommandLine(this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        if (this.isDtdOption) {
            this.printDtd();
            return 0;
        }
        XServerSampler xss = null;
        if (this.isHttpOption) {
            xss = new XServerSampler("web");
        } else if (this.isTxOption) {
            xss = new XServerSampler("tx");
        } else if (this.isCpuSunOption) {
            xss = new XServerSampler("cpusun");
        } else if (this.isServerOption) {
            xss = new XServerSampler("server");
        } else if (this.isJCACFSourceOption) {
            xss = new XServerSampler("jcacf");
            xss.setOnPattern(this.onPattern);
        } else if (this.isJoramQueueOption) {
            xss = new XServerSampler("joramQueue");
            xss.setOnPattern(this.onPattern);
        } else if (this.isDataSourceOption) {
            xss = new XServerSampler("datasource");
            xss.setOnPattern(this.onPattern);
        } else if (this.isServletOption) {
            xss = new XServerSampler("servlet");
            xss.setOnPattern(this.onPattern);
        } else if (this.isStatelessOption) {
            xss = new XServerSampler("stateless");
            xss.setOnPattern(this.onPattern);
        } else if (this.isStatefulOption) {
            xss = new XServerSampler("stateful");
            xss.setOnPattern(this.onPattern);
        } else if (this.isEntityOption) {
            xss = new XServerSampler("entity");
            xss.setOnPattern(this.onPattern);
        }
        String[] managee = JmxAP.getJmxTargets(this.commandLine.getOptionValues("target"));
        System.out.println(this.commandLine.getOptionValue("target"));
        managee[0] = this.commandLine.getOptionValue("target");
        if (managee != null && managee.length > 0) {
            for (int i = 0; i < managee.length; ++i) {
                xss.addManagee(managee[i], JmxAP.getJmxUrl(managee[i]));
            }
        } else {
            System.err.println("No target specified!");
            return 2;
        }
        PipedOutputStream out = new PipedOutputStream();
        PrintStream pout = new PrintStream(out);
        Outer outer = null;
        try {
            if (this.outputFilePath != null) {
                outer = new Outer(out, new File(this.outputFilePath));
            } else if (this.jasmineURI == null) {
                outer = new Outer(out, System.out);
            }
            if (this.jasmineURI != null) {
                if (outer == null) {
                    outer = JasmineConnector.connect(out, this.jasmineURI);
                } else {
                    Outer oldOuter = outer;
                    outer = JasmineConnector.connect(outer, this.jasmineURI);
                    new Thread(oldOuter).start();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.graphDef != null) {
            try {
                PipedOutputStream sink = new PipedOutputStream();
                outer.setSink(sink);
                Grapher gr = new Grapher(sink, this.graphDef);
                gr.start();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        new Thread(outer).start();
        xss.process(this.period, pout, cmdDispatcher);
        return 0;
    }

    public void help() {
        super.help();
        System.out.println("DTD for graph definitions:\n");
        this.printDtd();
    }

    private void printDtd() {
        LineNumberReader ln = Configurator.getDTD();
        if (ln != null) {
            try {
                String line = null;
                while ((line = ln.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public String summary() {
        return "Probes one or more J2EE servers and prints statistics";
    }

    public static void main(String[] args) {
        Poll p = new Poll();
        p.setArgs("poll", args);
        p.exec(null);
    }

    public void parseCommandLine(String[] args) throws ParseException {
        String s;
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        this.isHttpOption = this.commandLine.hasOption("http");
        this.isTxOption = this.commandLine.hasOption("tx");
        this.isCpuSunOption = this.commandLine.hasOption("cpusun");
        this.isServerOption = this.commandLine.hasOption("server");
        this.isDtdOption = this.commandLine.hasOption("dtd");
        this.isDataSourceOption = this.commandLine.hasOption("ds");
        if (this.isDataSourceOption) {
            this.onPattern = this.commandLine.getOptionValue("ds");
        }
        this.isJCACFSourceOption = this.commandLine.hasOption("jcacf");
        if (this.isJCACFSourceOption) {
            this.onPattern = this.commandLine.getOptionValue("jcacf");
        }
        this.isJoramQueueOption = this.commandLine.hasOption("joramq");
        if (this.isJoramQueueOption) {
            this.onPattern = this.commandLine.getOptionValue("joramq");
        }
        this.isServletOption = this.commandLine.hasOption("servlet");
        if (this.isServletOption) {
            this.onPattern = this.commandLine.getOptionValue("servlet");
        }
        this.isStatelessOption = this.commandLine.hasOption("slb");
        if (this.isStatelessOption) {
            this.onPattern = this.commandLine.getOptionValue("slb");
        }
        this.isStatefulOption = this.commandLine.hasOption("sfb");
        if (this.isStatefulOption) {
            this.onPattern = this.commandLine.getOptionValue("sfb");
        }
        this.isEntityOption = this.commandLine.hasOption("ent");
        if (this.isEntityOption) {
            this.onPattern = this.commandLine.getOptionValue("ent");
        }
        if ((s = this.commandLine.getOptionValue("p")) != null) {
            this.period = Long.parseLong(s);
        }
        if (this.commandLine.hasOption("graph")) {
            this.graphDef = this.commandLine.getOptionValue("graph");
        }
        if (this.commandLine.hasOption("f")) {
            this.outputFilePath = this.commandLine.getOptionValue("f");
        }
        if (this.commandLine.hasOption("jasmine")) {
            this.jasmineURI = this.commandLine.getOptionValue("jasmine");
        }
        if (this.commandLine.hasOption("s")) {
            this.separator = this.commandLine.getOptionValue("s");
            Outer.setSeparator(this.separator);
            SampleData.setSeparator(this.separator);
        }
    }

    private void setOptions() {
        this.options = new Options();
        Option period = new Option("p", "period", true, "Polling period");
        period.setRequired(false);
        period.setArgName("seconds");
        period.setArgs(1);
        this.options.addOption(period);
        OptionGroup polls = new OptionGroup();
        polls.setRequired(false);
        Option http = new Option("http", "http", false, "HTTP Statistics");
        polls.addOption(http);
        Option tx = new Option("tx", "tx", false, "Transaction Statistics");
        polls.addOption(tx);
        Option cpuSun = new Option("cpusun", "cpusun", false, "Sun CPU Statistics");
        polls.addOption(cpuSun);
        Option svr = new Option("server", "server", false, "Server Statistics");
        polls.addOption(svr);
        Option ds = new Option("ds", "ds", false, "DataSource Statistics");
        ds.setArgs(1);
        ds.setArgName("mbean pattern");
        polls.addOption(ds);
        Option jcacf = new Option("jcacf", "jcacf", false, "JCA Connection Factory Statistics");
        jcacf.setArgs(1);
        jcacf.setArgName("mbean pattern");
        polls.addOption(jcacf);
        Option joramq = new Option("joramq", "joramq", false, "Joram Queues Statistics");
        joramq.setArgs(1);
        joramq.setArgName("mbean pattern");
        polls.addOption(joramq);
        Option servlet = new Option("servlet", "servlet", true, "Servlet Statistics");
        servlet.setArgs(1);
        servlet.setArgName("mbean pattern");
        polls.addOption(servlet);
        Option stateless = new Option("slb", "stateless", true, "Stateless Session bean Statistics");
        stateless.setArgs(1);
        stateless.setArgName("mbean pattern");
        polls.addOption(stateless);
        Option stateful = new Option("sfb", "stateful", true, "Stateful Session bean Statistics");
        stateful.setArgs(1);
        stateful.setArgName("mbean pattern");
        polls.addOption(stateful);
        Option entity = new Option("ent", "entity", true, "Stateful Session bean Statistics");
        entity.setArgs(1);
        entity.setArgName("mbean pattern");
        polls.addOption(entity);
        Option mbean = new Option("mbean", "mbean", true, "Any MBean Statistics");
        mbean.setArgs(128);
        mbean.setArgName("mbean pattern and attributes");
        polls.addOption(mbean);
        Option dtd = new Option("dtd", "dtd", false, "DTD for graph definitions");
        polls.addOption(dtd);
        Option separator = new Option("s", "separator", true, "Set the column separator");
        separator.setRequired(false);
        separator.setArgName("separator");
        separator.setArgs(1);
        this.options.addOption(separator);
        this.options.addOptionGroup(polls);
        Option graph = new Option("graph", "graph", true, "Enable graphical output");
        graph.setRequired(false);
        graph.setArgName("graphDefinition");
        graph.setArgs(1);
        this.options.addOption(graph);
        Option file = new Option("f", "file", true, "Send output to file instead of stdout");
        file.setRequired(false);
        file.setArgName("path");
        file.setArgs(1);
        this.options.addOption(file);
        Option jasmine = new Option("jasmine", "jasmine", true, "Output logged data to jasmine (will disable stdout)");
        jasmine.setRequired(false);
        jasmine.setArgName("jasmineURI");
        jasmine.setArgs(1);
        this.options.addOption(jasmine);
        Option target = new Option("target", "target", true, "instances to poll");
        target.setRequired(false);
        target.setOptionalArg(true);
        target.setArgs(-2);
        target.setArgName("instances");
        this.options.addOption(target);
    }
}

