/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.DSData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XSampleData;

public class DSSampler
extends Sampler {
    private static final String[] attIds = new String[]{"currentOpened", "currentBusy", "currentInTx", "busyMin", "busyMax", "jdbcMinConnPool", "jdbcMaxConnPool", "jdbcConnMaxAge", "openedCount", "connectionFailures", "jdbcMaxOpenTime", "connectionLeaks", "jdbcMaxWaiters", "currentWaiters", "waitersHighRecent", "waitersHigh", "waiterCount", "jdbcMaxWaitTime", "waitingHigh", "waitingHighRecent", "waitingTime", "servedOpen", "rejectedOpen", "rejectedFull", "rejectedTimeout", "rejectedOther", "jdbcSamplingPeriod"};

    public DSSampler(JmxContext context) {
        super(context);
    }

    public String getDefaultOn() {
        return "*:j2eeType=JDBCDataSource,*";
    }

    protected SampleData newSampleData() {
        return new XSampleData();
    }

    protected SampleData poll(SampleData data) {
        this.pollDataSources((XSampleData)data);
        data.setValid(true);
        return data;
    }

    private void pollDataSources(XSampleData data) {
        data.setServerInfo(this.getName(), this.getServer(), this.getDomain());
        ObjectName[] oNames = this.context.getOnames().toArray(new ObjectName[this.context.getOnames().size()]);
        for (int i = 0; i < oNames.length; ++i) {
            data.setObjectName(oNames[i]);
            DSData dsdata = new DSData();
            dsdata.setObjectName(oNames[i]);
            dsdata.setSampleTime(System.currentTimeMillis());
            this.pollDataSource(oNames[i], dsdata);
            if (!dsdata.isValid()) continue;
            data.put(oNames[i], dsdata);
        }
    }

    private void pollDataSource(ObjectName on, DSData data) {
        try {
            Iterator it = this.getMBeanServerConnection().getAttributes(on, attIds).iterator();
            while (it.hasNext()) {
                data.setAttribute((Attribute)it.next());
            }
            data.setServerInfo(this.getName(), this.getServer(), this.getDomain());
            data.setValid(true);
            this.releaseMbeanServerConnection();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

