/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SFBData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XSampleData;

public class SFBSampler
extends Sampler {
    private static final String[] attIds = new String[]{"name", "cacheSize", "poolSize", "minPoolSize", "maxCacheSize", "sessionTimeOut"};

    public SFBSampler(JmxContext context) {
        super(context);
    }

    public String getDefaultOn() {
        return "*:j2eeType=StatefulSessionBean,*";
    }

    protected SampleData newSampleData() {
        return new XSampleData();
    }

    protected SampleData poll(SampleData data) {
        this.pollSFBs((XSampleData)data);
        data.setValid(true);
        return data;
    }

    private void pollSFBs(XSampleData data) {
        ObjectName[] oNames = this.context.getOnames().toArray(new ObjectName[this.context.getOnames().size()]);
        for (int i = 0; i < oNames.length; ++i) {
            SFBData sfbdata = new SFBData();
            sfbdata.setObjectName(oNames[i]);
            sfbdata.setSampleTime(System.currentTimeMillis());
            this.pollSFB(oNames[i], sfbdata);
            if (!sfbdata.isValid()) continue;
            data.put(oNames[i], sfbdata);
        }
    }

    private void pollSFB(ObjectName on, SFBData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        try {
            cnx = this.getMBeanServerConnection();
            al = cnx.getAttributes(on, attIds);
            this.releaseMbeanServerConnection();
            cnx = null;
            for (Attribute att : al) {
                data.setAttribute(att);
            }
            data.setServerInfo(this.getName(), this.getServer(), this.getDomain());
            data.setValid(true);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace(System.err);
        }
        catch (ReflectionException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

