/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

public class TxData
extends SampleData {
    private long commitedCount = 0L;
    private long pendingTx = 0L;
    private long rolledbackCount = 0L;
    private long timedOutTx = 0L;
    private double rateCommited = 0.0;
    private double commitRatio = 0.0;
    private double meanCommitRatio = 100.0;
    private static final String header = "txRate;pending;commit;rollback;timedOut;commitRatio;currentCommitRatio";

    public void compute(SampleData needs_cast) {
        TxData prev = (TxData)needs_cast;
        if (prev != null) {
            long deltaCommited = this.commitedCount - prev.commitedCount;
            this.rateCommited = 1000.0 * (double)deltaCommited / (double)(this.getSampleTime() - prev.getSampleTime());
            long deltaRolledback = this.rolledbackCount - prev.rolledbackCount;
            long deltaTx = deltaCommited + deltaRolledback;
            this.commitRatio = deltaTx > 0L ? 100.0 * (double)deltaCommited / (double)deltaTx : 100.0;
            long tx = this.commitedCount + this.rolledbackCount;
            this.meanCommitRatio = tx > 0L ? 100.0 * (double)this.commitedCount / (double)tx : 100.0;
        } else {
            this.rateCommited = 0.0;
            this.commitRatio = 100.0;
            this.meanCommitRatio = 100.0;
        }
    }

    protected String getInnerPrintHeader() {
        return header.replaceAll(";", TxData.getSeparator());
    }

    protected String getInnerPrintData() {
        return decimalFormat.format(this.getCommitedTxRate()) + TxData.getSeparator() + this.getPendingTxGauge() + TxData.getSeparator() + this.getCommittedTxCnt() + TxData.getSeparator() + this.getRolledbackTxCnt() + TxData.getSeparator() + this.getTimedOutTxCnt() + TxData.getSeparator() + decimalFormat.format(this.getMeanCommitRatio()) + TxData.getSeparator() + decimalFormat.format(this.getCommitTxRatio());
    }

    public void setCommittedTxCnt(long cnt) {
        this.commitedCount = cnt;
    }

    public long getCommittedTxCnt() {
        return this.commitedCount;
    }

    public void setPendingTxGauge(long gauge) {
        this.pendingTx = gauge;
    }

    public long getPendingTxGauge() {
        return this.pendingTx;
    }

    public void setRolledbackTxCnt(long cnt) {
        this.rolledbackCount = cnt;
    }

    public long getRolledbackTxCnt() {
        return this.rolledbackCount;
    }

    public void setTimedOutTxCnt(long cnt) {
        this.timedOutTx = cnt;
    }

    public long getTimedOutTxCnt() {
        return this.timedOutTx;
    }

    public double getCommitedTxRate() {
        return this.rateCommited;
    }

    public double getCommitTxRatio() {
        return this.commitRatio;
    }

    public double getMeanCommitRatio() {
        return this.meanCommitRatio;
    }
}

