/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAP;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SamplerFactory;

public class XServerSampler {
    private Map manageeURLs = new TreeMap();
    private String sampleType = null;
    private String onPattern = null;
    private SamplerContext[] context = null;
    private static final long SECOND = 1000L;

    public XServerSampler(String type) {
        this.sampleType = type;
    }

    public void addManagee(String name, String jmxUrl) {
        this.manageeURLs.put(name, jmxUrl);
    }

    public void setOnPattern(String objectNameAsString) {
        this.onPattern = objectNameAsString;
    }

    public void mbeanPoll(long period, PrintStream out) {
        boolean printHeader = true;
        while (true) {
            SamplerContext ctx = null;
            SampleData data = null;
            for (int i = 0; i < this.context.length; ++i) {
                block9: {
                    ctx = this.context[i];
                    data = null;
                    try {
                        data = ctx.getSampler().sample(ctx.getPreviousData());
                        if (data != null) {
                            if (printHeader) {
                                out.println(data.getPrintHeader());
                                printHeader = false;
                            }
                            data.printData(out);
                        }
                        if (!ctx.isStarted()) {
                            ctx.setStarted(true);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        if (!ctx.isStarted()) break block9;
                        System.err.println("Error sampling managee " + ctx.getName());
                    }
                }
                ctx.setPreviousData(data);
            }
            try {
                Thread.sleep(period * 1000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(long period, PrintStream out, CommandDispatcher cmdDispatcher) {
        LinkedList<SamplerContext> ss = new LinkedList<SamplerContext>();
        for (Map.Entry e : this.manageeURLs.entrySet()) {
            SamplerContext ctx = new SamplerContext();
            ctx.setName((String)e.getKey());
            ctx.setJmxUrl(JmxAP.getJmxUrl(ctx.getName()));
            ctx.setJmxap(new JmxAP(ctx.getJmxUrl(), cmdDispatcher));
            try {
                ObjectName j2eeinstance = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
                MBeanServerConnection mbscnx = ctx.getJmxap().getMBeanServerConnection();
                Iterator<ObjectName> onames = mbscnx.queryNames(j2eeinstance, null).iterator();
                while (ctx.getServer() == null) {
                    ObjectName oname = onames.next();
                    ctx.setServer((String)mbscnx.getAttribute(oname, "serverName"));
                    ctx.setDomain(oname.getDomain());
                }
            }
            catch (Exception ex) {
                ctx.setServer("unknown_server_name");
                ctx.setDomain("unknown_domain");
            }
            finally {
                ctx.getJmxap().releaseMBeanServerConnection();
            }
            Sampler s = SamplerFactory.newSampler(this.sampleType, ctx);
            ctx.setSampler(s);
            if (this.onPattern != null) {
                ctx.getSampler().setOn(this.onPattern);
            }
            ctx.getSampler().init();
            ss.add(ctx);
        }
        this.context = ss.toArray(new SamplerContext[ss.size()]);
        this.mbeanPoll(period, out);
    }
}

