/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.ServerData;

public class ServerSampler
extends Sampler {
    private ObjectName[] onServer = null;
    private ObjectName[] onJvm = null;
    private ObjectName[] onJtm = null;
    private ObjectName[] onGRP = null;
    private ObjectName[] onThreadPool = null;
    private ObjectName[] onSessions = null;
    private ObjectName[] onDS = null;
    private ObjectName[] onEntity = null;
    private ObjectName[] onSSB = null;
    private ObjectName[] onSFB = null;

    public ServerSampler(JmxContext context) {
        super(context);
    }

    public String getDefaultOn() {
        return null;
    }

    public void init() {
        this.onServer = this.queryON("*:j2eeType=J2EEServer,*");
        this.onJvm = this.queryON("*:j2eeType=JVM,*");
        this.onGRP = this.queryON("*:type=GlobalRequestProcessor,*");
        this.onThreadPool = this.queryON("*:type=ThreadPool,*");
        this.onSessions = this.queryON("*:type=Manager,*");
        this.onJtm = this.queryON("*:j2eeType=JTAResource,*");
        this.onDS = this.queryON("*:j2eeType=JDBCDataSource,*");
        this.onEntity = this.queryON("*:j2eeType=EntityBean,*");
        this.onSSB = this.queryON("*:j2eeType=StatelessSessionBean,*");
        this.onSFB = this.queryON("*:j2eeType=StatefulSessionBean,*");
    }

    protected SampleData newSampleData() {
        return new ServerData();
    }

    protected SampleData poll(SampleData data) {
        boolean status = true;
        this.pollServer((ServerData)data);
        status = status && data.isValid();
        this.pollJVM((ServerData)data);
        status = status && data.isValid();
        this.pollSessions((ServerData)data);
        status = status && data.isValid();
        this.pollThreadPool((ServerData)data);
        status = status && data.isValid();
        this.pollJTM((ServerData)data);
        status = status && data.isValid();
        this.pollDataSources((ServerData)data);
        status = status && data.isValid();
        this.pollGlobalRequestProcessor((ServerData)data);
        status = status && data.isValid();
        this.pollEntity((ServerData)data);
        status = status && data.isValid();
        this.pollSSB((ServerData)data);
        status = status && data.isValid();
        this.pollSFB((ServerData)data);
        status = status && data.isValid();
        data.setServerInfo(this.getName(), this.getServer(), this.getDomain());
        data.setValid(status);
        return data;
    }

    private void pollServer(ServerData data) {
        long totalMem = 0L;
        long usedMem = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"currentTotalMemory", "currentUsedMemory"};
        for (int i = 0; i < this.onServer.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onServer[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                totalMem += Long.parseLong(att.getValue().toString());
                att = (Attribute)it.next();
                usedMem += Long.parseLong(att.getValue().toString());
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setUsedMemory(usedMem);
        data.setMemory(totalMem);
        data.setServerInfo(this.getName(), this.getServer(), this.getDomain());
        if (this.onServer.length > 0) {
            data.setObjectName(this.onServer[0]);
        }
    }

    private void pollJVM(ServerData data) {
        int nbThreads = 0;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"allThreadsCount"};
        for (int i = 0; i < this.onJvm.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onJvm[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                nbThreads += Integer.parseInt(att.getValue().toString());
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setThreads(nbThreads);
    }

    private void pollSessions(ServerData data) {
        long nbSess = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"activeSessions"};
        for (int i = 0; i < this.onSessions.length; ++i) {
            if (this.onSessions[i] == null) continue;
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onSessions[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                nbSess += (long)((Integer)att.getValue()).intValue();
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setSessions(nbSess);
    }

    private void pollGlobalRequestProcessor(ServerData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"requestCount", "errorCount"};
        long reqCount = 0L;
        long errCount = 0L;
        for (int i = 0; i < this.onGRP.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onGRP[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                reqCount += (long)((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                errCount += (long)((Integer)att.getValue()).intValue();
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setHttpRequests(reqCount);
        data.setHttpErrors(errCount);
    }

    private void pollThreadPool(ServerData data) {
        long nbBusy = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"currentThreadsBusy"};
        for (int i = 0; i < this.onThreadPool.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onThreadPool[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                long busy = ((Integer)att.getValue()).intValue();
                nbBusy += busy == 1L ? 0L : busy;
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setPendingHttp(nbBusy);
    }

    private void pollJTM(ServerData data) {
        long txCount = 0L;
        long currentTxGauge = 0L;
        long rolledbackTx = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"totalCurrentTransactions", "totalCommittedTransactions", "totalRolledbackTransactions"};
        for (int i = 0; i < this.onJtm.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onJtm[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                currentTxGauge += Long.parseLong(att.getValue().toString());
                att = (Attribute)it.next();
                txCount += Long.parseLong(att.getValue().toString());
                att = (Attribute)it.next();
                rolledbackTx += Long.parseLong(att.getValue().toString());
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setCommitedTx(txCount);
        data.setRollbackTx(rolledbackTx);
        data.setPendingTx(currentTxGauge);
    }

    private void pollDataSources(ServerData data) {
        int cnxGauge = 0;
        int cnxFails = 0;
        int cnxLeaks = 0;
        int cnxWaits = 0;
        int cnxRejects = 0;
        int cnxBusy = 0;
        int cnxServed = 0;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"currentOpened", "connectionFailures", "connectionLeaks", "waiterCount", "rejectedOpen", "currentBusy", "servedOpen"};
        for (int i = 0; i < this.onDS.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onDS[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                cnxGauge += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxFails += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxLeaks += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxWaits += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxRejects += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxBusy += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                cnxServed += ((Integer)att.getValue()).intValue();
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setDSCnx(cnxGauge);
        data.setDSFails(cnxFails);
        data.setDSLeaks(cnxLeaks);
        data.setDSWaits(cnxWaits);
        data.setDSRejects(cnxRejects);
        data.setDSCnxBusy(cnxBusy);
        data.setDSServed(cnxServed);
    }

    private void pollEntity(ServerData data) {
        int entCacheNb = 0;
        int entPoolNb = 0;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"cacheSize", "currentInstancePoolSize"};
        if (this.onEntity != null) {
            for (int i = 0; i < this.onEntity.length; ++i) {
                try {
                    cnx = this.getMBeanServerConnection();
                    al = cnx.getAttributes(this.onEntity[i], attIds);
                    this.releaseMbeanServerConnection();
                    cnx = null;
                    Iterator it = al.iterator();
                    Attribute att = (Attribute)it.next();
                    entCacheNb += ((Integer)att.getValue()).intValue();
                    att = (Attribute)it.next();
                    entPoolNb += ((Integer)att.getValue()).intValue();
                    data.setValid(true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    e.getCause().printStackTrace(System.err);
                }
            }
        }
        data.setEntityCacheNb(entCacheNb);
        data.setEntityPoolNb(entPoolNb);
    }

    private void pollSSB(ServerData data) {
        int ssbCacheNb = 0;
        int ssbPoolNb = 0;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"cacheSize", "poolSize"};
        for (int i = 0; i < this.onSSB.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(this.onSSB[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                ssbCacheNb += ((Integer)att.getValue()).intValue();
                att = (Attribute)it.next();
                ssbPoolNb += ((Integer)att.getValue()).intValue();
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setSsbCacheNb(ssbCacheNb);
        data.setSsbPoolNb(ssbPoolNb);
    }

    private void pollSFB(ServerData data) {
        int sfbCacheNb = 0;
        int sfbPoolNb = 0;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"cacheSize", "poolSize"};
        if (this.onSFB != null) {
            for (int i = 0; i < this.onSFB.length; ++i) {
                try {
                    cnx = this.getMBeanServerConnection();
                    al = cnx.getAttributes(this.onSFB[i], attIds);
                    this.releaseMbeanServerConnection();
                    cnx = null;
                    Iterator it = al.iterator();
                    Attribute att = (Attribute)it.next();
                    sfbCacheNb += ((Integer)att.getValue()).intValue();
                    att = (Attribute)it.next();
                    sfbPoolNb += ((Integer)att.getValue()).intValue();
                    data.setValid(true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    e.getCause().printStackTrace(System.err);
                }
            }
        }
        data.setSfbCacheNb(sfbCacheNb);
        data.setSfbPoolNb(sfbPoolNb);
    }
}

