/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

public class WebData
extends SampleData {
    private long sessionGauge = 0L;
    private long sessionCount = 0L;
    private long httpRequestCount = 0L;
    private long procTimeCount = 0L;
    private long maxProcTime = 0L;
    private long pendingHttpRequests = 0L;
    private long httpErrorCount = 0L;
    private double httpRequestRate = 0.0;
    private double procTimePerRequest = 0.0;
    private static final String header = "sessions;rate;requests;pending;errors;sessionCount;meanTime;maxTime";

    public void compute(SampleData needs_cast) {
        WebData prev = (WebData)needs_cast;
        if (prev != null) {
            long deltaReq = this.httpRequestCount - prev.httpRequestCount;
            this.httpRequestRate = 1000.0 * (double)deltaReq / (double)(this.getSampleTime() - prev.getSampleTime());
            this.procTimePerRequest = deltaReq > 0L ? 1.0 * (double)(this.procTimeCount - prev.procTimeCount) / (double)deltaReq : 0.0;
        } else {
            this.httpRequestRate = 0.0;
            this.procTimePerRequest = 0.0;
        }
    }

    protected String getInnerPrintHeader() {
        return header.replaceAll(";", WebData.getSeparator());
    }

    protected String getInnerPrintData() {
        return this.getSessionGauge() + WebData.getSeparator() + decimalFormat.format(this.getHttpRequestRate()) + WebData.getSeparator() + this.getHttpRequestCount() + WebData.getSeparator() + this.getPendingHttpRequests() + WebData.getSeparator() + this.getHttpErrors() + WebData.getSeparator() + this.getSessionCount() + WebData.getSeparator() + decimalFormat.format(this.getProcTimePerRequest()) + WebData.getSeparator() + this.getMaxProcTime();
    }

    public void setSessionGauge(long nb) {
        this.sessionGauge = nb;
    }

    public long getSessionGauge() {
        return this.sessionGauge;
    }

    public void setSessionCount(long nb) {
        this.sessionCount = nb;
    }

    public long getSessionCount() {
        return this.sessionCount;
    }

    public void setHttpRequestCount(long cnt) {
        this.httpRequestCount = cnt;
    }

    public long getHttpRequestCount() {
        return this.httpRequestCount;
    }

    public void setProcTimeCount(long cnt) {
        this.procTimeCount = cnt;
    }

    public long getProcTimeCount() {
        return this.procTimeCount;
    }

    public void setMaxProcTime(long time) {
        this.maxProcTime = time;
    }

    public long getMaxProcTime() {
        return this.maxProcTime;
    }

    public void setPendingHttpRequests(long gauge) {
        this.pendingHttpRequests = gauge;
    }

    public long getPendingHttpRequests() {
        return this.pendingHttpRequests;
    }

    public void setHttpErrorsCount(long cnt) {
        this.httpErrorCount = cnt;
    }

    public long getHttpErrors() {
        return this.httpErrorCount;
    }

    public double getHttpRequestRate() {
        return this.httpRequestRate;
    }

    public double getProcTimePerRequest() {
        return this.procTimePerRequest;
    }
}

