/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Activator.java 4225 2009-07-01 15:15:52Z jlegrand $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.osgi;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/**
 * Activator providing a bundle context to the {@link CommandDispatcher}.
 * @author Loris Bouzonnet
 */
public class Activator implements BundleActivator {

    /**
     * Give a bundle context to the {@link CommandDispatcher}.
     * @param context bundle context
     */
    public void start(final BundleContext context) throws Exception {
        CommandDispatcher.setContext(context);
    }

    /**
     * Remove reference on bundle context from the {@link CommandDispatcher}.
     * @param context bundle context
     */
    public void stop(final BundleContext context) throws Exception {
        CommandDispatcher.removeContext();
    }

}
