/**
 * JASMINe
 * Copyright (C) 2005-2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CommandDispatcher.java 1866 2008-07-25 16:42:26Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.osgi.framework.BundleContext;

/**
 * This is the main class of the archive.
 *
 * It dispatches the processing of the command to the right class.
 *
 * The available commands in the current archive are retrieved
 * by introspection of the archive.
 */
public class CommandDispatcher extends org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher {

    /**
     * Bundle context.
     */
    private static BundleContext context = null;

    /**
     * Set a bundle context
     * @param context bundle context
     */
    public static void setContext(final BundleContext context) {
        CommandDispatcher.context = context;
        setOSGiEnabled(true);
    }

    /**
     * Delete the reference to the bundle context.
     */
    public static void removeContext() {
        setOSGiEnabled(false);
        context = null;
    }

    /**
     * Return an inputStreamReader for the specified resource, by using the bundle context.
     * @param name the resource name
     * @return an inputStreamReader for the specified resource
     * @throws IOException if an I/O exception occurs
     */
    @Override
    protected InputStreamReader getInputStreamReader(final String name) throws IOException {
        if(context == null) {
            return super.getInputStreamReader(name);
        }
        InputStream commandDefsInputStream =
            context.getBundle().getResource(name).openStream();
        return new InputStreamReader(commandDefsInputStream);
    }

    /**
     * Load and return a class for a given class name, by using the bundle context.
     * @param cname a class name
     * @return a loaded class for a given class name
     * @throws ClassNotFoundException if the class cannot be found
     */
    @Override
    protected Class<?> loadClass(final String cname) throws ClassNotFoundException {
        if(context == null) {
            return super.loadClass(cname);
        }
        return context.getBundle().loadClass(cname);
    }

}
