/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import org.ow2.jasmine.monitoring.mbeancmd.Command;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public abstract class AbstractCommand
implements Command {
    protected String name = null;
    protected String[] arguments = null;
    public static final SimpleDateFormat SIMPLEDATEFORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    protected Log logger = LogFactory.getLog(this.getClass());

    public abstract int exec(CommandDispatcher var1);

    public final String getName() {
        return this.name;
    }

    protected String getHelpDoc() {
        String classRadix = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1);
        String packName = this.getClass().getPackage().getName();
        String helpdoc = packName.substring(0, packName.lastIndexOf("."));
        helpdoc = helpdoc.replaceAll("[.]", "/") + "/helpdoc/" + classRadix + ".help";
        return helpdoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void help() {
        InputStream in0 = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getHelpDoc());
        if (in0 != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(in0));
            OutputStreamWriter out = new OutputStreamWriter(System.out);
            boolean goOn = true;
            char[] buf = new char[2048];
            while (goOn) {
                int read = in.read(buf);
                if (read > 0) {
                    out.write(buf, 0, read);
                    out.flush();
                    continue;
                }
                goOn = false;
                System.out.println();
            }
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (IOException e) {
                this.logger.error((Object)"Error closing the BufferedReader", new Object[]{e});
            }
            return;
            catch (IOException e) {
                try {
                    this.logger.error((Object)"Error reading help", new Object[]{e});
                    if (in == null) return;
                }
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        this.logger.error((Object)"Error closing the BufferedReader", new Object[]{e2});
                    }
                    throw throwable;
                }
                try {
                    in.close();
                    return;
                }
                catch (IOException e3) {
                    this.logger.error((Object)"Error closing the BufferedReader", new Object[]{e3});
                }
                return;
            }
        }
        System.out.println("No help available.");
    }

    public final void setArgs(String cmd, String[] args) {
        this.name = cmd.toLowerCase();
        this.arguments = args;
    }

    public abstract String summary();
}

