/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import javax.management.MBeanServerConnection;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import org.ow2.jasmine.adapter.jmx.pool.api.IJMXConnectionFactory;
import org.ow2.jasmine.adapter.jmx.pool.api.IJMXConnectionServer;
import org.ow2.jasmine.adapter.jmx.pool.api.JMXConnectionParam;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxCnxWrapper;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JmxAp {
    private CommandDispatcher cmdDispatcher = null;
    private String jmxUrl = "service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas";
    private IJMXConnectionFactory jmxFactory = null;
    private MBeanServerConnection jmxConnection = null;
    private IJMXConnectionServer jmxConnectionEmbedded = null;
    private Log logger = LogFactory.getLog(JmxAp.class);

    public JmxAp(String jmxUrl, CommandDispatcher cmdDispatcher) {
        this.jmxUrl = jmxUrl;
        if (cmdDispatcher != null) {
            this.cmdDispatcher = cmdDispatcher;
            if (this.cmdDispatcher.isEmbedded()) {
                this.connectJMX();
            }
        }
    }

    public JmxAp(CommandDispatcher cmdDispatcher) {
        this(JmxHelper.getDefaultJmxTarget(), cmdDispatcher);
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    public CommandDispatcher getCmdDispatcher() {
        return this.cmdDispatcher;
    }

    private void connectJMX() {
        Context ctx;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Connecting to the jmxFactory ...", new Object[0]);
        }
        if ((ctx = JmxHelper.getContext()) == null) {
            return;
        }
        String lookup = this.jmxUrl.replaceAll(":|/", "_");
        try {
            this.jmxFactory = (IJMXConnectionFactory)ctx.lookup(lookup);
        }
        catch (NamingException e) {
            this.logger.error((Object)"Error while looking up JMX Connection factory {0} : {1}.  An unmanaged JMX connection will be used instead. ", new Object[]{lookup, e.getMessage()});
        }
    }

    public MBeanServerConnection getMBeanServerConnection(boolean usePool) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getting MBeanserverConnection", new Object[0]);
        }
        if (this.jmxConnection == null) {
            String jmxUser = JmxHelper.getJmxUser(this.jmxUrl);
            String jmxPassword = JmxHelper.getJmxPassword(this.jmxUrl);
            String jmxProtocolProviderPackage = JmxHelper.getJmxProtocolProviderPackage(this.jmxUrl);
            if (usePool && this.cmdDispatcher != null && this.cmdDispatcher.isEmbedded() && this.jmxFactory != null) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"getting MBeanserverConnection using the pool", new Object[0]);
                    }
                    JMXConnectionParam jmxConnectionParam = new JMXConnectionParam(this.jmxUrl, jmxUser, jmxPassword, jmxProtocolProviderPackage);
                    this.jmxConnectionEmbedded = (IJMXConnectionServer)this.jmxFactory.getConnection((ConnectionSpec)jmxConnectionParam);
                    this.jmxConnection = this.jmxConnectionEmbedded;
                }
                catch (ResourceException e) {
                    this.logger.error((Object)"Error while getting a connection : {0}", new Object[]{e.getMessage()});
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Creating a simple JMX Connection without using the pool, URL is {0}", new Object[]{this.jmxUrl});
                }
                this.jmxConnection = new JmxCnxWrapper(this.jmxUrl, jmxUser, jmxPassword, jmxProtocolProviderPackage);
            }
        }
        return this.jmxConnection;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.getMBeanServerConnection(true);
    }

    public void closeMBeanServerConnection() {
        if (this.cmdDispatcher != null && this.cmdDispatcher.isEmbedded() && this.jmxFactory != null) {
            try {
                this.jmxConnectionEmbedded.close();
                this.jmxConnectionEmbedded = null;
            }
            catch (ResourceException e) {
                e.printStackTrace();
            }
        }
    }

    public void releaseMBeanServerConnection() {
        if (this.cmdDispatcher != null && this.cmdDispatcher.isEmbedded() && this.jmxFactory != null) {
            this.jmxConnectionEmbedded.release();
            this.jmxConnection = null;
        }
    }
}

