/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.IOException;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SessionBeanData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SessionBeanSampler;

public class SLBSampler
extends SessionBeanSampler {
    private static final String[] attIds = new String[]{"name", "cacheSize", "poolSize", "minPoolSize", "maxCacheSize", "sessionTimeOut"};
    private static final String[] extAttIds = new String[]{"totalProcessingTime", "numberOfCalls"};

    public SLBSampler(SamplerContext context) {
        super(context);
    }

    public String getDefaultOnPattern() {
        return "*:j2eeType=StatelessSessionBean,*";
    }

    protected void pollSessionBean(ObjectName on, SessionBeanData data) {
        AttributeList al = null;
        AttributeList alExt = null;
        MBeanServerConnection cnx = null;
        try {
            Attribute att;
            cnx = this.getMBeanServerConnection();
            al = cnx.getAttributes(on, attIds);
            alExt = cnx.getAttributes(on, extAttIds);
            this.releaseMbeanServerConnection();
            cnx = null;
            Iterator it = al.iterator();
            while (it.hasNext()) {
                att = (Attribute)it.next();
                data.setAttribute(att);
            }
            if (it.hasNext() && (att = (Attribute)it.next()).getValue() != null) {
                long totalProcessingTime = (Long)att.getValue();
                data.setAverageProcessingTime(totalProcessingTime);
            }
            if (it.hasNext() && (att = (Attribute)it.next()).getValue() != null) {
                long numberOfCalls = (Long)att.getValue();
                data.setAverageProcessingTime(numberOfCalls);
            }
            data.setServerInfo(this.getName(), this.getJmxUrl(), this.getServer(), this.getDomain());
            data.setValid(true);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace(System.err);
        }
        catch (ReflectionException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

