/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProbeResult.java 7181 2010-11-24 09:25:28Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.api;

import java.io.Serializable;
import java.util.Date;

public class ProbeResult implements Serializable {

    private static final long serialVersionUID = -6711641493993118511L;

    /**
     * Ident of the Probe
     */
    protected Integer probeId;
    protected String target;
    protected String bean;
    protected String attrname;
    protected String attrvalue;
    protected Date timestamp;

    public ProbeResult() {
    }

    public ProbeResult(Integer id) {
        this.probeId = id;
    }

    public Integer getProbeId() {
        return probeId;
    }

    public void setProbeId(Integer id) {
        probeId = id;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getBean() {
        return bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public String getAttrname() {
        return attrname;
    }

    public void setAttrname(String name) {
        this.attrname = name;
    }

    public String getAttrvalue() {
        return attrvalue;
    }

    public void setAttrvalue(String value) {
        this.attrvalue = value;
    }

    public Date getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Date value) {
        this.timestamp = value;
    }


}
