/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;

public class Mbean
extends AbstractCommand {
    private Options options = null;
    private CommandLine commandLine = null;
    private ObjectName on = null;
    private String method;
    private long period = 10000L;
    protected JmxAp jmxap = null;
    private CommandDispatcher cmdDispatcher = null;

    public Mbean() {
        this.setOptions();
    }

    public int exec(CommandDispatcher cmdDispatcher) {
        this.cmdDispatcher = cmdDispatcher;
        try {
            this.parseCommandLine(this.arguments);
            String[] targets = JmxHelper.getJmxTargets(this.commandLine.getOptionValues("target"));
            if (targets == null && JmxHelper.getDefaultJmxTarget() == null) {
                String message = "Target not found";
                this.logger.error((Object)message, new Object[0]);
                cmdDispatcher.setFailed(message);
                return 2;
            }
            this.jmxap = targets != null && targets.length > 0 ? new JmxAp(JmxHelper.getJmxUrl(targets[0]), this.cmdDispatcher) : new JmxAp(this.cmdDispatcher);
            this.process();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public String summary() {
        return "provides access to MBeans in a J2EE server";
    }

    public void parseCommandLine(String[] args) throws ParseException, MalformedObjectNameException {
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        this.setObjectName();
        this.setMethod();
        if (this.commandLine.hasOption("p")) {
            this.setPeriod();
        }
    }

    private void setObjectName() throws MalformedObjectNameException {
        String mbean = this.commandLine.getOptionValue("name");
        if (mbean.contains("\"")) {
            StringBuffer quotedMbean = new StringBuffer();
            StringTokenizer st = new StringTokenizer(mbean, "\"");
            quotedMbean.append(st.nextToken());
            while (st.hasMoreTokens()) {
                quotedMbean.append(ObjectName.quote(st.nextToken()));
                if (!st.hasMoreTokens()) continue;
                quotedMbean.append(st.nextToken());
            }
            this.on = new ObjectName(quotedMbean.toString());
        } else {
            this.on = new ObjectName(mbean);
        }
    }

    private void setMethod() {
        Option opt = this.options.getOption("-get");
        this.method = this.options.getOptionGroup(opt).getSelected();
    }

    private void setPeriod() throws NumberFormatException {
        Option opt = this.options.getOption("-p");
        this.period = Long.parseLong(opt.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mbeanQuery() throws Exception {
        try {
            MBeanServerConnection cnx = this.jmxap.getMBeanServerConnection();
            Set<ObjectName> s = cnx.queryNames(this.on, null);
            Iterator<ObjectName> it = s.iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
        }
        finally {
            this.jmxap.releaseMBeanServerConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mbeanGet() throws Exception {
        try {
            String[] atts = this.commandLine.getOptionValues("get");
            MBeanServerConnection cnx = this.jmxap.getMBeanServerConnection();
            if (atts == null) {
                MBeanAttributeInfo[] info = cnx.getMBeanInfo(this.on).getAttributes();
                atts = new String[info.length];
                for (int i = 0; i < atts.length; ++i) {
                    atts[i] = info[i].getName();
                }
            }
            AttributeList attl = cnx.getAttributes(this.on, atts);
            this.printMBeanGet(this.on, attl);
        }
        finally {
            this.jmxap.releaseMBeanServerConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mbeanMGet() throws Exception {
        try {
            String[] attsRequested;
            String[] atts = attsRequested = this.commandLine.getOptionValues("mget");
            MBeanServerConnection cnx = this.jmxap.getMBeanServerConnection();
            Set<ObjectName> s = cnx.queryNames(this.on, null);
            for (ObjectName onGot : s) {
                try {
                    if (attsRequested == null) {
                        MBeanAttributeInfo[] info = cnx.getMBeanInfo(onGot).getAttributes();
                        atts = new String[info.length];
                        for (int i = 0; i < atts.length; ++i) {
                            atts[i] = info[i].getName();
                        }
                    }
                    AttributeList attl = cnx.getAttributes(onGot, atts);
                    this.printMBeanGet(onGot, attl);
                }
                catch (Exception e) {
                    System.err.println("Error on mbean " + onGot);
                    e.printStackTrace(System.err);
                }
            }
        }
        finally {
            this.jmxap.releaseMBeanServerConnection();
        }
    }

    private void printMBeanGet(ObjectName ongot, AttributeList attl) {
        boolean verbose = this.commandLine.hasOption("v");
        if (verbose) {
            System.out.println("#MBEAN : " + ongot);
        }
        for (Attribute att : attl) {
            System.out.print(verbose ? att.getName() + "=" : "");
            if (att.getValue() != null && att.getValue().getClass().isArray()) {
                Object obj = att.getValue();
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    System.out.print((i == 0 ? "" : ",") + Array.get(obj, i));
                }
                System.out.println();
                continue;
            }
            System.out.println(att.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mbeanPoll() {
        String[] atts = this.getAttToPoll();
        this.printMBeanPollHeader(atts);
        MBeanServerConnection cnx = this.jmxap.getMBeanServerConnection();
        while (cnx != null) {
            try {
                cnx = this.jmxap.getMBeanServerConnection();
                Set<ObjectName> s = cnx.queryNames(this.on, null);
                Iterator<ObjectName> it = s.iterator();
                while (it.hasNext()) {
                    long t = System.currentTimeMillis();
                    ObjectName onGot = it.next();
                    try {
                        AttributeList attl = cnx.getAttributes(onGot, atts);
                        this.printMBeanPoll(t, attl);
                    }
                    catch (Exception e) {
                        System.err.println("Error on mbean " + onGot + " : " + e);
                    }
                }
                this.jmxap.releaseMBeanServerConnection();
            }
            catch (IOException e1) {
                e1.printStackTrace(System.err);
                break;
            }
            try {
                Thread.sleep(this.period);
            }
            catch (InterruptedException e) {
                this.jmxap.releaseMBeanServerConnection();
                break;
            }
            finally {
                this.jmxap.releaseMBeanServerConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAttToPoll() {
        String[] attsRequested;
        String[] atts = attsRequested = this.commandLine.getOptionValues("poll");
        try {
            MBeanServerConnection cnx = this.jmxap.getMBeanServerConnection();
            ObjectName onGot = null;
            Set<ObjectName> s = cnx.queryNames(this.on, null);
            Iterator<ObjectName> it = s.iterator();
            if (it.hasNext()) {
                onGot = it.next();
            }
            if (attsRequested == null) {
                MBeanAttributeInfo[] info = cnx.getMBeanInfo(onGot).getAttributes();
                atts = new String[info.length];
                for (int i = 0; i < atts.length; ++i) {
                    atts[i] = info[i].getName();
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace(System.err);
        }
        catch (IntrospectionException e) {
            e.printStackTrace(System.err);
        }
        catch (ReflectionException e) {
            e.printStackTrace(System.err);
        }
        finally {
            this.jmxap.releaseMBeanServerConnection();
        }
        return atts;
    }

    private void printMBeanPollHeader(String[] atts) {
        System.out.print("date;time;");
        for (int i = 0; i < atts.length; ++i) {
            System.out.print((i == 0 ? "" : ";") + atts[i]);
        }
        System.out.println();
    }

    private void printMBeanPoll(long t, AttributeList attl) {
        Date d = new Date(t);
        System.out.print(SIMPLEDATEFORMAT.format(d));
        System.out.print(";");
        System.out.print(t);
        System.out.print(";");
        for (Attribute att : attl) {
            if (att.getValue() != null && att.getValue().getClass().isArray()) {
                Object obj = att.getValue();
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    System.out.print((i == 0 ? "" : ",") + Array.get(obj, i));
                }
            } else {
                System.out.print(att.getValue());
            }
            System.out.print(";");
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mbeanInfo() {
        boolean verbose = this.commandLine.hasOption("v");
        try {
            MBeanServerConnection cnx = this.jmxap.getMBeanServerConnection();
            MBeanAttributeInfo[] info = cnx.getMBeanInfo(this.on).getAttributes();
            if (verbose) {
                System.out.println("#MBEAN : " + this.on);
            }
            for (int i = 0; i < info.length; ++i) {
                if (verbose) {
                    System.out.println("attribute " + info[i].getName() + " " + (info[i].isReadable() ? "R" : "") + (info[i].isWritable() ? "W" : "") + " " + info[i].getType() + " \"" + info[i].getDescription() + "\"");
                    continue;
                }
                System.out.println("attribute " + info[i].getName());
            }
            MBeanOperationInfo[] opinfo = cnx.getMBeanInfo(this.on).getOperations();
            for (int i = 0; i < opinfo.length; ++i) {
                if (verbose) {
                    System.out.print("operation " + opinfo[i].getReturnType() + " " + opinfo[i].getName() + "(");
                    MBeanParameterInfo[] sig = opinfo[i].getSignature();
                    for (int j = 0; j < sig.length; ++j) {
                        System.out.print(sig[j].getType() + " " + sig[j].getName() + " \"" + sig[j].getDescription() + "\"" + (j == sig.length - 1 ? "" : ","));
                    }
                    System.out.println(")");
                    continue;
                }
                System.out.println("operation " + opinfo[i].getName());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.err);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace(System.err);
        }
        catch (IntrospectionException e) {
            e.printStackTrace(System.err);
        }
        catch (ReflectionException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        finally {
            this.jmxap.releaseMBeanServerConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mbeanSet() throws Exception {
        Constructor<?> c;
        String[] attArgs = this.commandLine.getOptionValues("set");
        if (attArgs.length < 3) {
            throw new InvalidAttributeValueException("Wrong attribute specification");
        }
        String attName = attArgs[0];
        String attType = attArgs[1];
        Object attValue = null;
        Class<?> vc = Class.forName(attType);
        Class[] sig = new Class[]{Class.forName("java.lang.String")};
        if (vc.isArray()) {
            c = vc.getComponentType().getConstructor(sig);
            int sz = attArgs.length - 2;
            Object arrayOfValues = Array.newInstance(vc.getComponentType(), sz);
            for (int i = 0; i < sz; ++i) {
                String value = attArgs[2 + i];
                Object[] params = new Object[]{value};
                Array.set(arrayOfValues, i, c.newInstance(params));
            }
            attValue = arrayOfValues;
        } else {
            c = vc.getConstructor(sig);
            String value = attArgs[2];
            Object[] params = new Object[]{value};
            attValue = c.newInstance(params);
        }
        try {
            MBeanServerConnection cnx = this.jmxap.getMBeanServerConnection();
            Attribute att = new Attribute(attName, attValue);
            cnx.setAttribute(this.on, att);
        }
        finally {
            this.jmxap.releaseMBeanServerConnection();
        }
    }

    private String[] parseMethodSig(String[] args) {
        int nargs = 0;
        boolean newArg = true;
        for (int i = 1; i < args.length; ++i) {
            if (newArg) {
                ++nargs;
                newArg = false;
            }
            if (!",".equals(args[i])) continue;
            newArg = true;
        }
        if (nargs == 0) {
            return null;
        }
        String[] opSig = new String[nargs];
        boolean isType = true;
        int curArg = 0;
        for (int i = 1; i < args.length; ++i) {
            if (isType) {
                opSig[curArg++] = args[i];
                isType = false;
            }
            if (!",".equals(args[i])) continue;
            isType = true;
        }
        return opSig;
    }

    private Object[] parseMethodParams(String[] args, String[] opSig) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int nargs = opSig.length;
        Object[] opParams = new Object[nargs];
        boolean newArg = true;
        Vector<String> v = null;
        int curArg = 0;
        for (int i = 1; i < args.length; ++i) {
            if (newArg) {
                v = new Vector<String>();
                newArg = false;
                continue;
            }
            if (",".equals(args[i])) {
                Constructor<?> c;
                Object[] sParams = v.toArray();
                Class[] sig = new Class[]{Class.forName("java.lang.String")};
                Class<?> vc = Class.forName(opSig[curArg]);
                if (vc.isArray()) {
                    c = vc.getComponentType().getConstructor(sig);
                    Object arrayOfValues = Array.newInstance(vc.getComponentType(), sParams.length);
                    for (int j = 0; j < sParams.length; ++j) {
                        Object[] params = new Object[]{sParams[j]};
                        Array.set(arrayOfValues, j, c.newInstance(params));
                    }
                    opParams[curArg] = arrayOfValues;
                } else {
                    c = vc.getConstructor(sig);
                    Object[] params = new Object[]{sParams[0]};
                    opParams[curArg] = c.newInstance(params);
                }
                ++curArg;
                newArg = true;
                continue;
            }
            v.add(args[i]);
        }
        return opParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mbeanInvoke() throws Exception {
        Object result;
        String[] args = this.commandLine.getOptionValues("invoke");
        if (args.length == 0) {
            throw new JMException("Missing method name");
        }
        String op = args[0];
        String[] opSig = this.parseMethodSig(args);
        Object[] opParams = null;
        if (opSig != null) {
            opParams = this.parseMethodParams(args, opSig);
        }
        try {
            result = null;
            MBeanServerConnection cnx = this.jmxap.getMBeanServerConnection();
            result = cnx.invoke(this.on, op, opParams, opSig);
        }
        finally {
            this.jmxap.releaseMBeanServerConnection();
        }
        boolean verbose = this.commandLine.hasOption("v");
        if (verbose) {
            System.out.println("#MBEAN : " + this.on);
        }
        if (result != null) {
            if (result.getClass().isArray()) {
                Object[] to = (Object[])result;
                for (int i = 0; i < to.length; ++i) {
                    System.out.println(to[i]);
                }
            } else {
                System.out.println(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mbeanUnregister() {
        try {
            MBeanServerConnection cnx = this.jmxap.getMBeanServerConnection();
            cnx.unregisterMBean(this.on);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            this.jmxap.releaseMBeanServerConnection();
        }
    }

    private void setOptions() {
        this.options = new Options();
        this.options.addOption("v", "verbose", false, "Verbose mode");
        Option name = new Option("name", "objectName", true, "An ObjectName passed to every method");
        name.setRequired(true);
        name.setArgName("mbean name");
        name.setArgs(1);
        this.options.addOption(name);
        OptionGroup methods = new OptionGroup();
        methods.setRequired(true);
        Option query = new Option("query", "queryNames", false, "Query names to the Mbean server");
        methods.addOption(query);
        Option info = new Option("info", "mbeanInfo", false, "Get the mbean (meta-)information");
        methods.addOption(info);
        Option get = new Option("get", "get", true, "Get attributes from a MBean");
        get.setOptionalArg(true);
        get.setArgs(-2);
        get.setArgName("attributes");
        methods.addOption(get);
        Option mget = new Option("mget", "mget", true, "Get attributes from multiple MBeans");
        mget.setOptionalArg(true);
        mget.setArgs(-2);
        mget.setArgName("attributes");
        methods.addOption(mget);
        Option set = new Option("set", "set", true, "Set an attribute of a MBean");
        set.setOptionalArg(true);
        set.setArgs(-2);
        set.setArgName("attributes");
        methods.addOption(set);
        Option invoke = new Option("invoke", "invoke", true, "Invoke an operation of a MBean");
        invoke.setOptionalArg(true);
        invoke.setArgs(-2);
        invoke.setArgName("op params");
        methods.addOption(invoke);
        Option unregister = new Option("unregister", "unregister", false, "Unregister a mbean");
        methods.addOption(unregister);
        Option poll = new Option("poll", "poll", true, "Poll attributes from multiple MBeans periodically");
        poll.setOptionalArg(true);
        poll.setArgs(-2);
        poll.setArgName("attributes");
        methods.addOption(poll);
        Option period = new Option("p", "period", true, "Polling period");
        period.setArgName("period");
        period.setArgs(1);
        this.options.addOption(period);
        this.options.addOptionGroup(methods);
        Option target = new Option("target", "target", true, "instance to access to");
        target.setRequired(false);
        target.setOptionalArg(true);
        target.setArgs(-2);
        target.setArgName("instances");
        this.options.addOption(target);
    }

    public String toString() {
        return this.on.toString();
    }

    public void process() throws Exception {
        if ("query".equals(this.method)) {
            this.mbeanQuery();
        } else if ("get".equals(this.method)) {
            this.mbeanGet();
        } else if ("mget".equals(this.method)) {
            this.mbeanMGet();
        } else if ("info".equals(this.method)) {
            this.mbeanInfo();
        } else if ("set".equals(this.method)) {
            this.mbeanSet();
        } else if ("invoke".equals(this.method)) {
            this.mbeanInvoke();
        } else if ("poll".equals(this.method)) {
            this.mbeanPoll();
        } else if ("u".equals(this.method)) {
            this.mbeanUnregister();
        }
    }
}

