/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.commands;

import java.io.File;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.jasmine.monitoring.mbeancmd.AbstractCommand;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.Iner;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.graph.Grapher;

public class Replay
extends AbstractCommand {
    private Options options = null;
    private CommandLine commandLine = null;
    private String inputFile = null;
    private String graphDef = null;
    private String outputFilePath = null;
    private boolean isRowMatchOption = false;
    private String rowMatchPattern = null;
    private boolean isTimeMatchOption = false;
    private String[] timeMatchArgs = null;
    private boolean isSeparator = true;
    private String separator = ";";
    private boolean isColumnOption = false;
    private String[] columns = null;

    public Replay() {
        this.setOptions();
    }

    public int exec(CommandDispatcher cmdDispatcher) {
        Thread tailThread = null;
        try {
            this.parseCommandLine(this.arguments);
            PipedOutputStream out = null;
            PipedOutputStream src = null;
            PrintStream target = null;
            Iner iner = null;
            if (this.inputFile != null) {
                try {
                    iner = new Iner(new File(this.inputFile));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 1;
                }
            } else {
                iner = new Iner(System.in);
            }
            src = iner.getSink();
            Outer matchOuter = null;
            if (this.isTimeMatchOption || this.isRowMatchOption || this.isColumnOption) {
                out = new PipedOutputStream();
                target = new PrintStream(out);
                matchOuter = new Outer(src, target);
                matchOuter.setId("matchOuter");
                if (this.isTimeMatchOption) {
                    matchOuter.setTimeFilter(this.timeMatchArgs[0], "long".equalsIgnoreCase(this.timeMatchArgs[1]) ? null : this.timeMatchArgs[1], this.timeMatchArgs[2], this.timeMatchArgs[3]);
                }
                if (this.isRowMatchOption) {
                    matchOuter.setRegexp(this.rowMatchPattern);
                }
                if (this.isColumnOption) {
                    matchOuter.setFormatter(this.columns);
                }
                src = out;
            }
            if (this.graphDef != null) {
                try {
                    Grapher gr = new Grapher(src, this.graphDef);
                    gr.start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Outer outer = null;
                outer = this.outputFilePath != null ? new Outer(src, new File(this.outputFilePath)) : new Outer(src, System.out);
                outer.setId("ouput");
                tailThread = new Thread(outer);
                tailThread.start();
            }
            if (matchOuter != null) {
                new Thread(matchOuter).start();
            }
            if (iner != null) {
                new Thread(iner).start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
        if (tailThread != null) {
            try {
                tailThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.graphDef != null) {
            try {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException e) {
            }
        }
        return 0;
    }

    public String summary() {
        return "Replays captures from a text file.";
    }

    public static void main(String[] args) {
        Replay p = new Replay();
        p.setArgs("replay", args);
        p.exec(null);
    }

    public void parseCommandLine(String[] args) throws ParseException {
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        if (this.commandLine.hasOption("i")) {
            this.inputFile = this.commandLine.getOptionValue("i");
        }
        if (this.commandLine.hasOption("o")) {
            this.outputFilePath = this.commandLine.getOptionValue("o");
        }
        if (this.commandLine.hasOption("graph")) {
            this.graphDef = this.commandLine.getOptionValue("graph");
        }
        this.isRowMatchOption = this.commandLine.hasOption("m");
        if (this.isRowMatchOption) {
            this.rowMatchPattern = this.commandLine.getOptionValue("m");
        }
        this.isTimeMatchOption = this.commandLine.hasOption("t");
        if (this.isTimeMatchOption) {
            this.timeMatchArgs = this.commandLine.getOptionValues("t");
        }
        this.isSeparator = this.commandLine.hasOption("s");
        if (this.isSeparator) {
            this.separator = this.commandLine.getOptionValue("s");
            Outer.setSeparator(this.separator);
        }
        this.isColumnOption = this.commandLine.hasOption("c");
        if (this.isColumnOption) {
            this.columns = this.commandLine.getOptionValues("c");
        }
    }

    private void setOptions() {
        this.options = new Options();
        Option ifile = new Option("i", "input", true, "Input file");
        ifile.setRequired(false);
        ifile.setArgName("file");
        ifile.setArgs(1);
        this.options.addOption(ifile);
        Option rowmatch = new Option("m", "match", true, "Row matching pattern");
        rowmatch.setRequired(false);
        rowmatch.setArgName("pattern");
        rowmatch.setArgs(1);
        this.options.addOption(rowmatch);
        Option timematch = new Option("t", "time", true, "Time interval matching pattern");
        timematch.setRequired(false);
        timematch.setArgName("field format from to");
        timematch.setArgs(4);
        this.options.addOption(timematch);
        Option columns = new Option("c", "columns", true, "Specifies the columns to print");
        columns.setRequired(false);
        columns.setArgName("column list");
        columns.setArgs(-2);
        this.options.addOption(columns);
        Option graph = new Option("graph", "graph", true, "Enable graphical output");
        graph.setRequired(false);
        graph.setArgName("graphDefinition");
        graph.setArgs(1);
        this.options.addOption(graph);
        Option file = new Option("o", "output", true, "Send output to file instead of stdout");
        file.setRequired(false);
        file.setArgName("path");
        file.setArgs(1);
        this.options.addOption(file);
        Option separator = new Option("s", "separator", true, "Set the column separator");
        separator.setRequired(false);
        separator.setArgName("separator");
        separator.setArgs(1);
        this.options.addOption(separator);
    }
}

