/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JProbeCmdThread.java 7786 2011-03-03 10:51:54Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.osgi.internal;

import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineProbe;
import org.ow2.jasmine.monitoring.mbeancmd.CmdThread;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher.CommandStatus;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * This class extend CmdThread for 2 purposes:
 * - run a special CommandDispatcher for OSGi
 * - manages properly the command status
 * @author durieuxp
 */
public class JProbeCmdThread extends CmdThread {

    private Log logger = LogFactory.getLog(this.getClass());

    protected CommandDispatcher commandDispatcher = null;

    protected JasmineProbe probe = null;

    protected String error = null;

    protected ProbeServiceImpl probeservice;

    public JProbeCmdThread(String[] args, long delay, JasmineProbe probe, ProbeServiceImpl probeservice) {
        super(args, delay);
        this.probe = probe;
        this.probeservice = probeservice;
    }

    public void setDispatcher(CommandDispatcher disp) {
        commandDispatcher = disp;
    }

    /**
     * Start the command.
     */
    @Override
    public void run() {
        if (delay != 0) {
            final long time = System.currentTimeMillis();
            synchronized (this) {
                while(System.currentTimeMillis() < time + delay) {
                    try {
                        wait(delay);
                    } catch (InterruptedException e) {
                        this.interrupt();
                    }
                }
            }
        }

        // Solve issue when using JNDI inside this OSGi bundle
        this.setContextClassLoader(getClass().getClassLoader());

        // Start my CommandDispatcher, customized for OSGi
        // return only on failure, or when command is finished
        JProbeCommandDispatcher.start(commandArgs, this);
    }

    public void tryStop() {
        if (commandDispatcher != null) {
            commandDispatcher.stopCommand();
        }
    }

    @Override
    public void setCmdStatus(String cmdStatus) {
        this.cmdStatus = cmdStatus;
        // Set the Probe Status
        if (cmdStatus.equals(CommandStatus.STARTED.toString())) {
            probe.setState(JasmineProbe.PROBE_STARTED);
        } else if (cmdStatus.equals(CommandStatus.RUNNING.toString())) {
            probe.setState(JasmineProbe.PROBE_RUNNING);
        } else if (cmdStatus.equals(CommandStatus.FAILED.toString())) {
            probe.setState(JasmineProbe.PROBE_FAILED);
            probe.setError(getErrorMessage());
        } else if (cmdStatus.equals(CommandStatus.STOPPED.toString())) {
            probe.setState(JasmineProbe.PROBE_STOPPED);
        }
        // Publish change for client
        probeservice.publishChange(probe);
    }

}
