/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import javax.management.MBeanServerConnection;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxCnxWrapper;
import org.ow2.jasmine.monitoring.mbeancmd.JmxHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JmxAp {
    private CommandDispatcher cmdDispatcher = null;
    private String jmxUrl = "service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas";
    private MBeanServerConnection jmxConnection = null;
    private Log logger = LogFactory.getLog(JmxAp.class);

    public JmxAp(String jmxUrl, CommandDispatcher cmdDispatcher) {
        this.jmxUrl = jmxUrl;
        if (cmdDispatcher != null) {
            this.cmdDispatcher = cmdDispatcher;
        }
    }

    public JmxAp(CommandDispatcher cmdDispatcher) {
        this(JmxHelper.getDefaultJmxTarget(), cmdDispatcher);
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    public CommandDispatcher getCmdDispatcher() {
        return this.cmdDispatcher;
    }

    public MBeanServerConnection getMBeanServerConnection(boolean usePool) {
        if (this.jmxConnection == null) {
            this.logger.debug((Object)"getting MBeanserverConnection", new Object[0]);
            String jmxUser = JmxHelper.getJmxUser(this.jmxUrl);
            String jmxPassword = JmxHelper.getJmxPassword(this.jmxUrl);
            String jmxProtocolProviderPackage = JmxHelper.getJmxProtocolProviderPackage(this.jmxUrl);
            this.jmxConnection = new JmxCnxWrapper(this.jmxUrl, jmxUser, jmxPassword, jmxProtocolProviderPackage);
        }
        return this.jmxConnection;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.getMBeanServerConnection(false);
    }

    public void releaseMBeanServerConnection() {
        if (this.cmdDispatcher != null && !this.cmdDispatcher.isEmbedded()) {
            return;
        }
    }
}

