/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.osgi.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.BundleContext;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.jasmine.monitoring.mbeancmd.api.ConsoleOutput;
import org.ow2.jasmine.monitoring.mbeancmd.api.EventswitchOutput;
import org.ow2.jasmine.monitoring.mbeancmd.api.FileOutput;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineOutput;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasminePoll;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineProbe;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineProbeException;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineProbeListener;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineProbeManager;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineStat;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineTarget;
import org.ow2.jasmine.monitoring.mbeancmd.generated.Cmdname;
import org.ow2.jasmine.monitoring.mbeancmd.generated.Media;
import org.ow2.jasmine.monitoring.mbeancmd.generated.ObjectFactory;
import org.ow2.jasmine.monitoring.mbeancmd.generated.Output;
import org.ow2.jasmine.monitoring.mbeancmd.generated.PollType;
import org.ow2.jasmine.monitoring.mbeancmd.generated.ProbeConfig;
import org.ow2.jasmine.monitoring.mbeancmd.generated.ProbeData;
import org.ow2.jasmine.monitoring.mbeancmd.generated.StatusType;
import org.ow2.jasmine.monitoring.mbeancmd.generated.Target;
import org.ow2.jasmine.monitoring.mbeancmd.osgi.internal.JProbeCmdThread;
import org.ow2.jasmine.monitoring.mbeancmd.osgi.internal.JProbeCommandDispatcher;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="JasmineProbeManager")
@Provides
public class ProbeServiceImpl
implements JasmineProbeManager,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __Fcontext;
    private BundleContext context;
    private boolean __FprobeConfig;
    private ProbeConfig probeConfig;
    private boolean __FprobeList;
    private Map<Integer, JasmineProbe> probeList;
    private boolean __FoutputList;
    private Map<String, JasmineOutput> outputList;
    private boolean __FtargetList;
    private Map<String, JasmineTarget> targetList;
    private boolean __Fstartlist;
    private ArrayList<Integer> startlist;
    private boolean __FmbeanCmdList;
    private Map<Integer, JProbeCmdThread> mbeanCmdList;
    private boolean __FprobeCount;
    private int probeCount;
    private boolean __FprobeListeners;
    private List<JasmineProbeListener> probeListeners;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __McreateOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput;
    private boolean __MchangeOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput;
    private boolean __MremoveOutput$java_lang_String;
    private boolean __MfindOutput$java_lang_String;
    private boolean __MgetOutputs;
    private boolean __McreateTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget;
    private boolean __MchangeTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget;
    private boolean __MremoveTarget$java_lang_String;
    private boolean __MfindTarget$java_lang_String;
    private boolean __MgetTargets;
    private boolean __McreateProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe;
    private boolean __MchangeProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe;
    private boolean __MremoveProbe$int;
    private boolean __MremoveAllProbes;
    private boolean __MstartProbe$int;
    private boolean __MstopProbe$int;
    private boolean __MstopAllProbes;
    private boolean __MstartAllProbes;
    private boolean __MgetProbes;
    private boolean __MsaveConfig$java_lang_String;
    private boolean __MloadConfig$java_lang_String;
    private boolean __MaddProbeListener$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbeListener;
    private boolean __MgetMBeans$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget$java_lang_String;
    private boolean __MpublishChange$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe;
    private boolean __MisTargetUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget;
    private boolean __MisOutputUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput;
    private boolean __MsetTargetState$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget;
    private boolean __MreadConfig;
    private boolean __MsaveConfigFile$java_io_OutputStream;
    private boolean __MloadConfigFile$java_io_InputStream;
    private boolean __MbuildArgList$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe;
    private boolean __MgetNewProbeId;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    ProbeConfig __getprobeConfig() {
        if (!this.__FprobeConfig) {
            return this.probeConfig;
        }
        return (ProbeConfig)this.__IM.onGet((Object)this, "probeConfig");
    }

    void __setprobeConfig(ProbeConfig probeConfig) {
        if (!this.__FprobeConfig) {
            this.probeConfig = probeConfig;
            return;
        }
        this.__IM.onSet((Object)this, "probeConfig", (Object)probeConfig);
    }

    Map __getprobeList() {
        if (!this.__FprobeList) {
            return this.probeList;
        }
        return (Map)this.__IM.onGet((Object)this, "probeList");
    }

    void __setprobeList(Map map) {
        if (!this.__FprobeList) {
            this.probeList = map;
            return;
        }
        this.__IM.onSet((Object)this, "probeList", (Object)map);
    }

    Map __getoutputList() {
        if (!this.__FoutputList) {
            return this.outputList;
        }
        return (Map)this.__IM.onGet((Object)this, "outputList");
    }

    void __setoutputList(Map map) {
        if (!this.__FoutputList) {
            this.outputList = map;
            return;
        }
        this.__IM.onSet((Object)this, "outputList", (Object)map);
    }

    Map __gettargetList() {
        if (!this.__FtargetList) {
            return this.targetList;
        }
        return (Map)this.__IM.onGet((Object)this, "targetList");
    }

    void __settargetList(Map map) {
        if (!this.__FtargetList) {
            this.targetList = map;
            return;
        }
        this.__IM.onSet((Object)this, "targetList", (Object)map);
    }

    ArrayList __getstartlist() {
        if (!this.__Fstartlist) {
            return this.startlist;
        }
        return (ArrayList)this.__IM.onGet((Object)this, "startlist");
    }

    void __setstartlist(ArrayList arrayList) {
        if (!this.__Fstartlist) {
            this.startlist = arrayList;
            return;
        }
        this.__IM.onSet((Object)this, "startlist", (Object)arrayList);
    }

    Map __getmbeanCmdList() {
        if (!this.__FmbeanCmdList) {
            return this.mbeanCmdList;
        }
        return (Map)this.__IM.onGet((Object)this, "mbeanCmdList");
    }

    void __setmbeanCmdList(Map map) {
        if (!this.__FmbeanCmdList) {
            this.mbeanCmdList = map;
            return;
        }
        this.__IM.onSet((Object)this, "mbeanCmdList", (Object)map);
    }

    int __getprobeCount() {
        if (!this.__FprobeCount) {
            return this.probeCount;
        }
        Object object = this.__IM.onGet((Object)this, "probeCount");
        Integer n = (Integer)object;
        return n;
    }

    void __setprobeCount(int n) {
        if (!this.__FprobeCount) {
            this.probeCount = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "probeCount", (Object)n2);
    }

    List __getprobeListeners() {
        if (!this.__FprobeListeners) {
            return this.probeListeners;
        }
        return (List)this.__IM.onGet((Object)this, "probeListeners");
    }

    void __setprobeListeners(List list) {
        if (!this.__FprobeListeners) {
            this.probeListeners = list;
            return;
        }
        this.__IM.onSet((Object)this, "probeListeners", (Object)list);
    }

    public ProbeServiceImpl(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ProbeServiceImpl(InstanceManager _manager, BundleContext bc) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(this.getClass()));
        this.__setprobeConfig(null);
        this.__setprobeList(new HashMap());
        this.__setoutputList(new HashMap());
        this.__settargetList(new HashMap());
        this.__setstartlist(new ArrayList());
        this.__setmbeanCmdList(new HashMap());
        this.__setprobeCount(0);
        this.__setprobeListeners(new ArrayList());
        this.__setcontext(bc);
    }

    public synchronized void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        this.__getlogger().debug((Object)"Start JasmineProbeManager", new Object[0]);
        JProbeCommandDispatcher.setContext(this.__getcontext());
        try {
            this.readConfig();
        }
        catch (Exception e) {
            this.__getlogger().error((Object)"Cannot read configuration", new Object[0]);
        }
        Iterator i$ = this.__getstartlist().iterator();
        while (i$.hasNext()) {
            int probeid = (Integer)i$.next();
            try {
                this.startProbe(probeid);
            }
            catch (JasmineProbeException e) {
                this.__getlogger().error((Object)("Cannot start probe " + probeid + ":" + e.getMessage()), new Object[0]);
            }
        }
    }

    public synchronized void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        this.__getlogger().debug((Object)"Stop JasmineProbeManager", new Object[0]);
        try {
            this.stopAllProbes();
        }
        catch (Exception e) {
            this.__getlogger().error((Object)"Cannot stop all probes", new Object[0]);
        }
        JProbeCommandDispatcher.removeContext();
    }

    public synchronized void createOutput(JasmineOutput jasmineOutput) throws JasmineProbeException {
        if (!this.__McreateOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput) {
            this.__createOutput(jasmineOutput);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput", new Object[]{jasmineOutput});
            this.__createOutput(jasmineOutput);
            this.__IM.onExit((Object)this, "createOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput", throwable);
            throw throwable;
        }
    }

    private void __createOutput(JasmineOutput newoutput) throws JasmineProbeException {
        String id = newoutput.getName();
        this.__getlogger().debug((Object)("Create Output " + id), new Object[0]);
        JasmineOutput output = (JasmineOutput)this.__getoutputList().get(id);
        if (output != null) {
            this.__getlogger().debug((Object)("output already known: " + newoutput), new Object[0]);
            if (output.equals((Object)newoutput)) {
                return;
            }
            if (this.isOutputUsed(output)) {
                this.__getlogger().warn((Object)("oldoutput:" + output), new Object[0]);
                this.__getlogger().warn((Object)("newoutput:" + newoutput), new Object[0]);
                throw new JasmineProbeException(id + " already known with another definition");
            }
            this.__getoutputList().remove(id);
        }
        this.__getoutputList().put(id, newoutput);
    }

    public synchronized void changeOutput(JasmineOutput jasmineOutput) throws JasmineProbeException {
        if (!this.__MchangeOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput) {
            this.__changeOutput(jasmineOutput);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput", new Object[]{jasmineOutput});
            this.__changeOutput(jasmineOutput);
            this.__IM.onExit((Object)this, "changeOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput", throwable);
            throw throwable;
        }
    }

    private void __changeOutput(JasmineOutput newoutput) throws JasmineProbeException {
        String name = newoutput.getName();
        this.__getlogger().debug((Object)("Change Output " + name), new Object[0]);
        JasmineOutput output = (JasmineOutput)this.__getoutputList().get(name);
        if (output == null) {
            this.__getlogger().warn((Object)("output unknown: " + newoutput), new Object[0]);
            throw new JasmineProbeException(name + " unknown");
        }
        ArrayList<JasmineProbe> plist = new ArrayList<JasmineProbe>();
        for (JasmineProbe probe : this.__getprobeList().values()) {
            if (!probe.getOutputList().contains(output)) continue;
            if (probe.getState() == 2 || probe.getState() == 1) {
                this.__getlogger().warn((Object)("output " + name + " is used in a running probe"), new Object[0]);
                throw new JasmineProbeException("Cannot change output currently used in a Probe");
            }
            plist.add(probe);
        }
        for (JasmineProbe probe : plist) {
            probe.getOutputList().remove(output);
            probe.getOutputList().add(newoutput);
        }
        this.__getoutputList().put(name, newoutput);
    }

    public synchronized void removeOutput(String string) throws JasmineProbeException {
        if (!this.__MremoveOutput$java_lang_String) {
            this.__removeOutput(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeOutput$java_lang_String", new Object[]{string});
            this.__removeOutput(string);
            this.__IM.onExit((Object)this, "removeOutput$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeOutput$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeOutput(String name) throws JasmineProbeException {
        this.__getlogger().debug((Object)("Remove output " + name), new Object[0]);
        JasmineOutput output = (JasmineOutput)this.__getoutputList().get(name);
        if (output == null) {
            throw new JasmineProbeException("Unknown Output: " + name);
        }
        ArrayList<JasmineProbe> plist = new ArrayList<JasmineProbe>();
        for (JasmineProbe probe : this.__getprobeList().values()) {
            if (!probe.getOutputList().contains(output)) continue;
            if (probe.getState() == 2 || probe.getState() == 1) {
                this.__getlogger().warn((Object)("output " + name + " is used in a running probe"), new Object[0]);
                throw new JasmineProbeException("Cannot remove output currently used in a Probe");
            }
            plist.add(probe);
        }
        for (JasmineProbe probe : plist) {
            probe.getOutputList().remove(output);
        }
        this.__getoutputList().remove(name);
    }

    public synchronized JasmineOutput findOutput(String string) {
        JasmineOutput jasmineOutput;
        if (!this.__MfindOutput$java_lang_String) {
            return this.__findOutput(string);
        }
        try {
            this.__IM.onEntry((Object)this, "findOutput$java_lang_String", new Object[]{string});
            jasmineOutput = this.__findOutput(string);
            this.__IM.onExit((Object)this, "findOutput$java_lang_String", (Object)jasmineOutput);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findOutput$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineOutput;
    }

    private JasmineOutput __findOutput(String name) {
        JasmineOutput po = (JasmineOutput)this.__getoutputList().get(name);
        return po;
    }

    public synchronized Collection<JasmineOutput> getOutputs() throws JasmineProbeException {
        Collection<JasmineOutput> collection;
        if (!this.__MgetOutputs) {
            return this.__getOutputs();
        }
        try {
            this.__IM.onEntry((Object)this, "getOutputs", new Object[0]);
            collection = this.__getOutputs();
            this.__IM.onExit((Object)this, "getOutputs", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutputs", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<JasmineOutput> __getOutputs() throws JasmineProbeException {
        this.__getlogger().debug((Object)"getOutputs", new Object[0]);
        return this.__getoutputList().values();
    }

    public synchronized void createTarget(JasmineTarget jasmineTarget) throws JasmineProbeException {
        if (!this.__McreateTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget) {
            this.__createTarget(jasmineTarget);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", new Object[]{jasmineTarget});
            this.__createTarget(jasmineTarget);
            this.__IM.onExit((Object)this, "createTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", throwable);
            throw throwable;
        }
    }

    private void __createTarget(JasmineTarget newtarget) throws JasmineProbeException {
        String id = newtarget.getName();
        this.__getlogger().debug((Object)("create Target " + id), new Object[0]);
        JasmineTarget target = (JasmineTarget)this.__gettargetList().get(id);
        if (target != null) {
            this.__getlogger().debug((Object)("target already known: " + newtarget), new Object[0]);
            if (target.equals((Object)newtarget)) {
                return;
            }
            if (this.isTargetUsed(target)) {
                this.__getlogger().warn((Object)("oldtarget:" + target), new Object[0]);
                this.__getlogger().warn((Object)("newtarget:" + newtarget), new Object[0]);
                throw new JasmineProbeException(id + " already known with another definition");
            }
            this.__gettargetList().remove(id);
        }
        newtarget.setState(0);
        this.__gettargetList().put(id, newtarget);
    }

    public synchronized void changeTarget(JasmineTarget jasmineTarget) throws JasmineProbeException {
        if (!this.__MchangeTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget) {
            this.__changeTarget(jasmineTarget);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", new Object[]{jasmineTarget});
            this.__changeTarget(jasmineTarget);
            this.__IM.onExit((Object)this, "changeTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", throwable);
            throw throwable;
        }
    }

    private void __changeTarget(JasmineTarget newtarget) throws JasmineProbeException {
        String name = newtarget.getName();
        this.__getlogger().debug((Object)("change Target " + name), new Object[0]);
        JasmineTarget target = (JasmineTarget)this.__gettargetList().get(name);
        if (target == null) {
            this.__getlogger().warn((Object)("target unknown: " + newtarget), new Object[0]);
            throw new JasmineProbeException(name + " unknown");
        }
        ArrayList<JasmineProbe> plist = new ArrayList<JasmineProbe>();
        for (JasmineProbe probe : this.__getprobeList().values()) {
            if (!probe.getTargetList().contains(target)) continue;
            if (probe.getState() == 2 || probe.getState() == 1) {
                this.__getlogger().warn((Object)("target " + name + " is used in the running probe " + probe.getId()), new Object[0]);
                throw new JasmineProbeException("Cannot change target currently used in a Probe");
            }
            plist.add(probe);
        }
        for (JasmineProbe probe : plist) {
            probe.getTargetList().remove(target);
            probe.getTargetList().add(newtarget);
        }
        newtarget.setState(0);
        this.__gettargetList().put(name, newtarget);
    }

    public synchronized void removeTarget(String string) throws JasmineProbeException {
        if (!this.__MremoveTarget$java_lang_String) {
            this.__removeTarget(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeTarget$java_lang_String", new Object[]{string});
            this.__removeTarget(string);
            this.__IM.onExit((Object)this, "removeTarget$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeTarget$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeTarget(String name) throws JasmineProbeException {
        this.__getlogger().debug((Object)("Remove target " + name), new Object[0]);
        JasmineTarget target = (JasmineTarget)this.__gettargetList().get(name);
        if (target == null) {
            throw new JasmineProbeException("Unknown target: " + name);
        }
        ArrayList<JasmineProbe> plist = new ArrayList<JasmineProbe>();
        for (JasmineProbe probe : this.__getprobeList().values()) {
            if (!probe.getTargetList().contains(target)) continue;
            if (probe.getState() == 2 || probe.getState() == 1) {
                this.__getlogger().warn((Object)("target " + name + " is used in a running probe"), new Object[0]);
                throw new JasmineProbeException("Cannot remove target currently used in a Probe");
            }
            plist.add(probe);
        }
        for (JasmineProbe probe : plist) {
            probe.getTargetList().remove(target);
        }
        this.__gettargetList().remove(name);
    }

    public synchronized JasmineTarget findTarget(String string) {
        JasmineTarget jasmineTarget;
        if (!this.__MfindTarget$java_lang_String) {
            return this.__findTarget(string);
        }
        try {
            this.__IM.onEntry((Object)this, "findTarget$java_lang_String", new Object[]{string});
            jasmineTarget = this.__findTarget(string);
            this.__IM.onExit((Object)this, "findTarget$java_lang_String", (Object)jasmineTarget);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findTarget$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineTarget;
    }

    private JasmineTarget __findTarget(String targetId) {
        JasmineTarget pt = (JasmineTarget)this.__gettargetList().get(targetId);
        return pt;
    }

    public synchronized Collection<JasmineTarget> getTargets() {
        Collection<JasmineTarget> collection;
        if (!this.__MgetTargets) {
            return this.__getTargets();
        }
        try {
            this.__IM.onEntry((Object)this, "getTargets", new Object[0]);
            collection = this.__getTargets();
            this.__IM.onExit((Object)this, "getTargets", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTargets", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<JasmineTarget> __getTargets() {
        this.__getlogger().debug((Object)"getTargets", new Object[0]);
        return this.__gettargetList().values();
    }

    public synchronized int createProbe(JasmineProbe jasmineProbe) throws JasmineProbeException {
        int n;
        if (!this.__McreateProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe) {
            return this.__createProbe(jasmineProbe);
        }
        try {
            this.__IM.onEntry((Object)this, "createProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", new Object[]{jasmineProbe});
            n = this.__createProbe(jasmineProbe);
            this.__IM.onExit((Object)this, "createProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", throwable);
            throw throwable;
        }
        return n;
    }

    private int __createProbe(JasmineProbe probe) throws JasmineProbeException {
        int probeId = this.getNewProbeId();
        probe.setId(probeId);
        this.__getlogger().debug((Object)("creating probe #" + probeId + " : " + probe.getName()), new Object[0]);
        probe.setState(0);
        this.__getprobeList().put(probeId, probe);
        return probeId;
    }

    public synchronized void changeProbe(JasmineProbe jasmineProbe) throws JasmineProbeException {
        if (!this.__MchangeProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe) {
            this.__changeProbe(jasmineProbe);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", new Object[]{jasmineProbe});
            this.__changeProbe(jasmineProbe);
            this.__IM.onExit((Object)this, "changeProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", throwable);
            throw throwable;
        }
    }

    private void __changeProbe(JasmineProbe newprobe) throws JasmineProbeException {
        int probeId = newprobe.getId();
        JasmineProbe probe = (JasmineProbe)this.__getprobeList().get(probeId);
        if (probe == null) {
            throw new JasmineProbeException("Unknown Id: " + probeId);
        }
        JProbeCmdThread cmd = (JProbeCmdThread)this.__getmbeanCmdList().get(probeId);
        if (cmd != null && cmd.getCmdStatus().equals(CommandDispatcher.CommandStatus.RUNNING.toString())) {
            throw new JasmineProbeException("Cannot change a probe that is running");
        }
        this.__getprobeList().put(probeId, newprobe);
    }

    public synchronized void removeProbe(int n) throws JasmineProbeException {
        if (!this.__MremoveProbe$int) {
            this.__removeProbe(n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeProbe$int", new Object[]{new Integer(n)});
            this.__removeProbe(n);
            this.__IM.onExit((Object)this, "removeProbe$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeProbe$int", throwable);
            throw throwable;
        }
    }

    private void __removeProbe(int probeId) throws JasmineProbeException {
        JasmineProbe probe = (JasmineProbe)this.__getprobeList().get(probeId);
        if (probe == null) {
            throw new JasmineProbeException("Unknown Id: " + probeId);
        }
        this.__getlogger().debug((Object)("removing " + probeId), new Object[0]);
        this.__getprobeList().remove(probeId);
        JProbeCmdThread cmd = (JProbeCmdThread)this.__getmbeanCmdList().remove(probeId);
        if (cmd != null && cmd.getCmdStatus().equals(CommandDispatcher.CommandStatus.STARTED.toString())) {
            this.stopProbe(probeId);
        }
    }

    public synchronized void removeAllProbes() throws JasmineProbeException {
        if (!this.__MremoveAllProbes) {
            this.__removeAllProbes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeAllProbes", new Object[0]);
            this.__removeAllProbes();
            this.__IM.onExit((Object)this, "removeAllProbes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeAllProbes", throwable);
            throw throwable;
        }
    }

    private void __removeAllProbes() throws JasmineProbeException {
        ArrayList probes = new ArrayList(this.__getprobeList().values());
        for (JasmineProbe probe : probes) {
            int probeId = probe.getId();
            this.stopProbe(probeId);
            this.__getlogger().debug((Object)("removing " + probeId), new Object[0]);
            this.__getprobeList().remove(probeId);
        }
    }

    public synchronized void startProbe(int n) throws JasmineProbeException {
        if (!this.__MstartProbe$int) {
            this.__startProbe(n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startProbe$int", new Object[]{new Integer(n)});
            this.__startProbe(n);
            this.__IM.onExit((Object)this, "startProbe$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startProbe$int", throwable);
            throw throwable;
        }
    }

    private void __startProbe(int probeId) throws JasmineProbeException {
        JasmineProbe probe = (JasmineProbe)this.__getprobeList().get(probeId);
        if (probe == null) {
            throw new JasmineProbeException("Unknown Id: " + probeId);
        }
        this.__getlogger().debug((Object)("starting " + probeId), new Object[0]);
        String[] args = this.buildArgList(probe);
        JProbeCmdThread cmd = (JProbeCmdThread)this.__getmbeanCmdList().get(probeId);
        if (cmd != null) {
            if (cmd.getCmdStatus().equals(CommandDispatcher.CommandStatus.RUNNING.toString())) {
                this.__getlogger().info((Object)("Probe already running: " + probeId), new Object[0]);
                return;
            }
            if (cmd.getCmdStatus().equals(CommandDispatcher.CommandStatus.STARTED.toString())) {
                this.__getlogger().info((Object)("Probe already started: " + probeId), new Object[0]);
                return;
            }
            this.__getlogger().debug((Object)"Restarting probe", new Object[0]);
            cmd.tryStop();
            this.__getmbeanCmdList().remove(probeId);
        }
        cmd = new JProbeCmdThread(args, 0L, probe, this);
        this.__getmbeanCmdList().put(probeId, cmd);
        if (this.__getlogger().isDebugEnabled()) {
            this.__getlogger().debug((Object)"Starting Probe with args:", new Object[0]);
            for (int i = 0; i < args.length; ++i) {
                this.__getlogger().debug((Object)("args[" + i + "]=" + args[i]), new Object[0]);
            }
        }
        cmd.start();
    }

    public synchronized void stopProbe(int n) throws JasmineProbeException {
        if (!this.__MstopProbe$int) {
            this.__stopProbe(n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopProbe$int", new Object[]{new Integer(n)});
            this.__stopProbe(n);
            this.__IM.onExit((Object)this, "stopProbe$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopProbe$int", throwable);
            throw throwable;
        }
    }

    private void __stopProbe(int probeId) throws JasmineProbeException {
        JasmineProbe probe = (JasmineProbe)this.__getprobeList().get(probeId);
        if (probe == null) {
            throw new JasmineProbeException("Unknown Id: " + probeId);
        }
        this.__getlogger().debug((Object)("stopping " + probeId), new Object[0]);
        JProbeCmdThread cmd = (JProbeCmdThread)this.__getmbeanCmdList().remove(probeId);
        if (cmd == null) {
            this.__getlogger().debug((Object)"Already stopped", new Object[0]);
            return;
        }
        cmd.tryStop();
        this.__getlogger().debug((Object)"probe has been stopped", new Object[0]);
    }

    public synchronized void stopAllProbes() throws JasmineProbeException {
        if (!this.__MstopAllProbes) {
            this.__stopAllProbes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopAllProbes", new Object[0]);
            this.__stopAllProbes();
            this.__IM.onExit((Object)this, "stopAllProbes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopAllProbes", throwable);
            throw throwable;
        }
    }

    private void __stopAllProbes() throws JasmineProbeException {
        for (JasmineProbe probe : this.__getprobeList().values()) {
            try {
                this.stopProbe(probe.getId());
            }
            catch (Exception e) {
                this.__getlogger().warn((Object)("could not stop probe " + probe.getId() + " :" + e), new Object[0]);
            }
        }
    }

    public synchronized void startAllProbes() throws JasmineProbeException {
        if (!this.__MstartAllProbes) {
            this.__startAllProbes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startAllProbes", new Object[0]);
            this.__startAllProbes();
            this.__IM.onExit((Object)this, "startAllProbes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startAllProbes", throwable);
            throw throwable;
        }
    }

    private void __startAllProbes() throws JasmineProbeException {
        for (JasmineProbe probe : this.__getprobeList().values()) {
            try {
                this.startProbe(probe.getId());
            }
            catch (Exception e) {
                this.__getlogger().warn((Object)("could not start probe " + probe.getId() + " :" + e), new Object[0]);
            }
        }
    }

    public synchronized Collection<JasmineProbe> getProbes() {
        Collection<JasmineProbe> collection;
        if (!this.__MgetProbes) {
            return this.__getProbes();
        }
        try {
            this.__IM.onEntry((Object)this, "getProbes", new Object[0]);
            collection = this.__getProbes();
            this.__IM.onExit((Object)this, "getProbes", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProbes", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<JasmineProbe> __getProbes() {
        this.__getlogger().debug((Object)"listAllProbes", new Object[0]);
        return this.__getprobeList().values();
    }

    public synchronized void saveConfig(String string) throws JasmineProbeException {
        if (!this.__MsaveConfig$java_lang_String) {
            this.__saveConfig(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "saveConfig$java_lang_String", new Object[]{string});
            this.__saveConfig(string);
            this.__IM.onExit((Object)this, "saveConfig$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "saveConfig$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __saveConfig(String path) throws JasmineProbeException {
        this.__getlogger().debug((Object)"saveConfig", new Object[0]);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(JProp.getConfDir(), "probe-config.xml"));
        }
        catch (FileNotFoundException e) {
            throw new JasmineProbeException("Cannot write the config file 'probe-config.xml'" + e);
        }
        if (outputStream == null) {
            throw new JasmineProbeException("Cannot write the config file 'probe-config.xml'");
        }
        try {
            this.saveConfigFile(outputStream);
        }
        catch (Exception e) {
            this.__getlogger().warn((Object)("could not save config: " + e), new Object[0]);
            throw new JasmineProbeException("could not save config: " + e.getMessage());
        }
    }

    public synchronized void loadConfig(String string) throws JasmineProbeException {
        if (!this.__MloadConfig$java_lang_String) {
            this.__loadConfig(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfig$java_lang_String", new Object[]{string});
            this.__loadConfig(string);
            this.__IM.onExit((Object)this, "loadConfig$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfig$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __loadConfig(String path) throws JasmineProbeException {
        this.__getlogger().debug((Object)("loadConfig: " + path), new Object[0]);
        try {
            this.loadConfigFile(new FileInputStream(path));
        }
        catch (Exception e) {
            this.__getlogger().warn((Object)("could not load config: " + e), new Object[0]);
            throw new JasmineProbeException("could not load config: " + e.getMessage());
        }
    }

    public synchronized void addProbeListener(JasmineProbeListener jasmineProbeListener) {
        if (!this.__MaddProbeListener$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbeListener) {
            this.__addProbeListener(jasmineProbeListener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addProbeListener$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbeListener", new Object[]{jasmineProbeListener});
            this.__addProbeListener(jasmineProbeListener);
            this.__IM.onExit((Object)this, "addProbeListener$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbeListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addProbeListener$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbeListener", throwable);
            throw throwable;
        }
    }

    private void __addProbeListener(JasmineProbeListener listener) {
        this.__getprobeListeners().add(listener);
    }

    public Set<ObjectName> getMBeans(JasmineTarget jasmineTarget, String string) throws JasmineProbeException {
        Set<ObjectName> set;
        if (!this.__MgetMBeans$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget$java_lang_String) {
            return this.__getMBeans(jasmineTarget, string);
        }
        try {
            this.__IM.onEntry((Object)this, "getMBeans$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget$java_lang_String", new Object[]{jasmineTarget, string});
            set = this.__getMBeans(jasmineTarget, string);
            this.__IM.onExit((Object)this, "getMBeans$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget$java_lang_String", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getMBeans$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget$java_lang_String", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<ObjectName> __getMBeans(JasmineTarget jt, String pattern) throws JasmineProbeException {
        JasmineTarget target = (JasmineTarget)this.__gettargetList().get(jt.getName());
        JmxAp jmxap = new JmxAp(target.getJmxUrl(), null);
        Set<ObjectName> names = null;
        try {
            MBeanServerConnection cnx = jmxap.getMBeanServerConnection();
            ObjectName on = new ObjectName(pattern);
            names = cnx.queryNames(on, null);
            target.setState(1);
        }
        catch (IOException e) {
            this.__getlogger().error((Object)("cannot reach target: " + e), new Object[0]);
            target.setState(2);
            throw new JasmineProbeException("cannot reach target: " + e.getMessage());
        }
        catch (MalformedObjectNameException e) {
            this.__getlogger().error((Object)("Malformed ObjectName: " + e), new Object[0]);
            throw new JasmineProbeException("Cannot Get MBean List: Malformed ObjectName");
        }
        catch (NullPointerException e) {
            this.__getlogger().error((Object)("NPE: " + e), new Object[0]);
            e.printStackTrace();
            throw new JasmineProbeException("Cannot Get MBean List");
        }
        finally {
            jmxap.releaseMBeanServerConnection();
        }
        return names;
    }

    public void publishChange(JasmineProbe jasmineProbe) {
        if (!this.__MpublishChange$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe) {
            this.__publishChange(jasmineProbe);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "publishChange$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", new Object[]{jasmineProbe});
            this.__publishChange(jasmineProbe);
            this.__IM.onExit((Object)this, "publishChange$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "publishChange$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", throwable);
            throw throwable;
        }
    }

    private void __publishChange(JasmineProbe probe) {
        if (probe.getState() == 2) {
            for (JasmineTarget target : probe.getTargetList()) {
                target.setState(1);
            }
        }
        for (JasmineProbeListener listener : this.__getprobeListeners()) {
            listener.notifyEvent(probe);
        }
    }

    private boolean isTargetUsed(JasmineTarget jasmineTarget) {
        boolean bl;
        if (!this.__MisTargetUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget) {
            return this.__isTargetUsed(jasmineTarget);
        }
        try {
            this.__IM.onEntry((Object)this, "isTargetUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", new Object[]{jasmineTarget});
            bl = this.__isTargetUsed(jasmineTarget);
            this.__IM.onExit((Object)this, "isTargetUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isTargetUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isTargetUsed(JasmineTarget target) {
        for (JasmineProbe probe : this.__getprobeList().values()) {
            if (!probe.getTargetList().contains(target)) continue;
            return true;
        }
        return false;
    }

    private boolean isOutputUsed(JasmineOutput jasmineOutput) {
        boolean bl;
        if (!this.__MisOutputUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput) {
            return this.__isOutputUsed(jasmineOutput);
        }
        try {
            this.__IM.onEntry((Object)this, "isOutputUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput", new Object[]{jasmineOutput});
            bl = this.__isOutputUsed(jasmineOutput);
            this.__IM.onExit((Object)this, "isOutputUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isOutputUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isOutputUsed(JasmineOutput output) {
        for (JasmineProbe probe : this.__getprobeList().values()) {
            if (!probe.getOutputList().contains(output)) continue;
            return true;
        }
        return false;
    }

    private void setTargetState(JasmineTarget jasmineTarget) {
        if (!this.__MsetTargetState$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget) {
            this.__setTargetState(jasmineTarget);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTargetState$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", new Object[]{jasmineTarget});
            this.__setTargetState(jasmineTarget);
            this.__IM.onExit((Object)this, "setTargetState$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTargetState$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __setTargetState(JasmineTarget target) {
        JmxAp jmxap = new JmxAp(target.getJmxUrl(), null);
        try {
            MBeanServerConnection cnx = jmxap.getMBeanServerConnection();
            cnx.getDefaultDomain();
            target.setState(1);
        }
        catch (IOException e) {
            this.__getlogger().error((Object)("cannot reach target: " + e), new Object[0]);
            target.setState(2);
        }
        finally {
            jmxap.releaseMBeanServerConnection();
        }
    }

    private void readConfig() throws Exception {
        if (!this.__MreadConfig) {
            this.__readConfig();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "readConfig", new Object[0]);
            this.__readConfig();
            this.__IM.onExit((Object)this, "readConfig", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "readConfig", throwable);
            throw throwable;
        }
    }

    private void __readConfig() throws Exception {
        String configurationFile = "probe-config.xml";
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        InputStream resource = null;
        try {
            resource = loader.getResourceAsStream(configurationFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        if (resource == null) {
            this.__getlogger().error((Object)"Cannot find probe-config.xml", new Object[0]);
            return;
        }
        this.__getlogger().debug((Object)"Parsing probe-config.xml", new Object[0]);
        this.loadConfigFile(resource);
    }

    private void saveConfigFile(OutputStream outputStream) throws Exception {
        if (!this.__MsaveConfigFile$java_io_OutputStream) {
            this.__saveConfigFile(outputStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "saveConfigFile$java_io_OutputStream", new Object[]{outputStream});
            this.__saveConfigFile(outputStream);
            this.__IM.onExit((Object)this, "saveConfigFile$java_io_OutputStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "saveConfigFile$java_io_OutputStream", throwable);
            throw throwable;
        }
    }

    private void __saveConfigFile(OutputStream resource) throws Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.__setprobeConfig(new ProbeConfig());
            ArrayList<Output> olist = new ArrayList<Output>();
            for (JasmineOutput jo : this.__getoutputList().values()) {
                Output output = new Output();
                output.setId(jo.getName());
                if (jo instanceof ConsoleOutput) {
                    output.setDest(Media.CONSOLE);
                } else if (jo instanceof EventswitchOutput) {
                    output.setDest(Media.JASMINE);
                    output.setHost(((EventswitchOutput)jo).getHost());
                    output.setPort(((EventswitchOutput)jo).getPort());
                } else if (jo instanceof FileOutput) {
                    output.setDest(Media.LOGFILE);
                    output.setPath(((FileOutput)jo).getPath());
                }
                olist.add(output);
            }
            this.__getprobeConfig().setOutput(olist);
            ArrayList<Target> tlist = new ArrayList<Target>();
            for (JasmineTarget jt : this.__gettargetList().values()) {
                Target target = new Target();
                target.setId(jt.getName());
                target.setUrl(jt.getJmxUrl());
                target.setUser(jt.getUser());
                target.setPassword(jt.getPassword());
                tlist.add(target);
            }
            this.__getprobeConfig().setTarget(tlist);
            ArrayList<ProbeData> plist = new ArrayList<ProbeData>();
            for (JasmineProbe jp : this.__getprobeList().values()) {
                ProbeData pdata = new ProbeData();
                if (jp instanceof JasmineStat) {
                    JasmineStat stat = (JasmineStat)jp;
                    pdata.setCmd(Cmdname.STAT);
                    pdata.setFilter(stat.getFilter());
                    String attlist = new String();
                    for (String attr : stat.getAttributes()) {
                        attlist = attlist + attr + " ";
                    }
                    pdata.setArgs(attlist);
                } else if (jp instanceof JasminePoll) {
                    JasminePoll poll = (JasminePoll)jp;
                    pdata.setCmd(Cmdname.POLL);
                    PollType ptype = null;
                    if (poll.getWhich().equals("jcacf")) {
                        ptype = PollType.JCACF;
                    }
                    if (poll.getWhich().equals("cpusun")) {
                        ptype = PollType.CPUSUN;
                    }
                    if (poll.getWhich().equals("tx")) {
                        ptype = PollType.TX;
                    }
                    if (poll.getWhich().equals("http")) {
                        ptype = PollType.HTTP;
                    }
                    if (poll.getWhich().equals("ds")) {
                        ptype = PollType.DS;
                    }
                    if (poll.getWhich().equals("ent")) {
                        ptype = PollType.ENT;
                    }
                    if (poll.getWhich().equals("slb")) {
                        ptype = PollType.SLB;
                    }
                    if (poll.getWhich().equals("sfb")) {
                        ptype = PollType.SFB;
                    }
                    if (poll.getWhich().equals("servlet")) {
                        ptype = PollType.SERVLET;
                    }
                    if (poll.getWhich().equals("joramq")) {
                        ptype = PollType.JORAMQ;
                    }
                    pdata.setWhich(ptype);
                    pdata.setFilter(poll.getFilter());
                }
                String period = new Long(jp.getPeriod()).toString();
                pdata.setPeriod(new BigInteger(period));
                String refreshperiod = new Long(jp.getRefreshPeriod()).toString();
                pdata.setRefreshPeriod(new BigInteger(refreshperiod));
                pdata.setSeparator(jp.getSeparator());
                ArrayList<String> tnlist = new ArrayList<String>();
                for (JasmineTarget target : jp.getTargetList()) {
                    tnlist.add(target.getName());
                }
                pdata.setTarget(tnlist);
                ArrayList<String> onlist = new ArrayList<String>();
                for (JasmineOutput output : jp.getOutputList()) {
                    onlist.add(output.getName());
                }
                pdata.setOutput(onlist);
                switch (jp.getState()) {
                    case 0: 
                    case 3: {
                        pdata.setStatus(StatusType.STOPPED);
                        break;
                    }
                    case 1: 
                    case 2: {
                        pdata.setStatus(StatusType.STARTED);
                    }
                }
                plist.add(pdata);
            }
            this.__getprobeConfig().setProbe(plist);
            marshaller.marshal((Object)this.__getprobeConfig(), resource);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                resource.close();
            }
            catch (IOException ignore) {}
        }
    }

    private void loadConfigFile(InputStream inputStream) throws Exception {
        if (!this.__MloadConfigFile$java_io_InputStream) {
            this.__loadConfigFile(inputStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfigFile$java_io_InputStream", new Object[]{inputStream});
            this.__loadConfigFile(inputStream);
            this.__IM.onExit((Object)this, "loadConfigFile$java_io_InputStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfigFile$java_io_InputStream", throwable);
            throw throwable;
        }
    }

    private void __loadConfigFile(InputStream resource) throws Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.__setprobeConfig((ProbeConfig)unmarshaller.unmarshal(resource));
            for (Output output : this.__getprobeConfig().getOutput()) {
                ConsoleOutput jo = null;
                switch (output.getDest()) {
                    case CONSOLE: {
                        jo = new ConsoleOutput();
                        break;
                    }
                    case JASMINE: {
                        jo = new EventswitchOutput();
                        EventswitchOutput eo = (EventswitchOutput)jo;
                        eo.setHost(output.getHost());
                        eo.setPort(output.getPort());
                        break;
                    }
                    case LOGFILE: {
                        jo = new FileOutput();
                        FileOutput fo = (FileOutput)jo;
                        fo.setPath(output.getPath());
                    }
                }
                jo.setName(output.getId());
                this.createOutput((JasmineOutput)jo);
            }
            for (Target target : this.__getprobeConfig().getTarget()) {
                JasmineTarget jt = new JasmineTarget();
                jt.setName(target.getId());
                jt.setJmxUrl(target.getUrl());
                jt.setUser(target.getUser());
                jt.setPassword(target.getPassword());
                this.createTarget(jt);
            }
            block21: for (ProbeData pdata : this.__getprobeConfig().getProbe()) {
                JasmineStat probe = null;
                switch (pdata.getCmd()) {
                    case STAT: {
                        JasmineStat stat;
                        probe = stat = new JasmineStat();
                        stat.setFilter(pdata.getFilter());
                        ArrayList<String> sattr = new ArrayList<String>();
                        if (pdata.getArgs() != null) {
                            StringTokenizer stk = new StringTokenizer(pdata.getArgs());
                            while (stk.hasMoreTokens()) {
                                String tok = stk.nextToken();
                                sattr.add(tok);
                            }
                        }
                        stat.setAttributes(sattr.toArray(new String[sattr.size()]));
                        break;
                    }
                    case POLL: {
                        JasminePoll poll = new JasminePoll();
                        probe = poll;
                        if (pdata.getWhich() == null) {
                            this.__getlogger().error((Object)"incorrect probe definition: missing attribute 'which'", new Object[0]);
                            continue block21;
                        }
                        poll.setWhich(pdata.getWhich().value());
                        poll.setFilter(pdata.getFilter());
                        break;
                    }
                    case SNAP: {
                        this.__getlogger().error((Object)"Not Supported probe type: SNAP", new Object[0]);
                        continue block21;
                    }
                }
                probe.setName(pdata.getCmd().value());
                probe.setPeriod(pdata.getPeriod().intValue());
                probe.setRefreshPeriod(pdata.getRefreshPeriod().intValue());
                probe.setSeparator(pdata.getSeparator());
                ArrayList<JasmineTarget> tlist = new ArrayList<JasmineTarget>();
                for (String tid : pdata.getTarget()) {
                    JasmineTarget target = this.findTarget(tid);
                    if (target == null) {
                        this.__getlogger().error((Object)("cannot find target " + tid), new Object[0]);
                        continue;
                    }
                    tlist.add(target);
                }
                probe.setTargetList(tlist);
                ArrayList<JasmineOutput> olist = new ArrayList<JasmineOutput>();
                for (String oid : pdata.getOutput()) {
                    JasmineOutput output = this.findOutput(oid);
                    if (output == null) {
                        this.__getlogger().error((Object)("cannot find output " + oid), new Object[0]);
                        continue;
                    }
                    olist.add(output);
                }
                probe.setOutputList(olist);
                Integer id = this.createProbe((JasmineProbe)probe);
                if (pdata.getStatus() == null || !pdata.getStatus().value().equals("started")) continue;
                this.__getstartlist().add(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                resource.close();
            }
            catch (IOException ignore) {}
        }
    }

    private String[] buildArgList(JasmineProbe jasmineProbe) throws JasmineProbeException {
        String[] stringArray;
        if (!this.__MbuildArgList$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe) {
            return this.__buildArgList(jasmineProbe);
        }
        try {
            this.__IM.onEntry((Object)this, "buildArgList$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", new Object[]{jasmineProbe});
            stringArray = this.__buildArgList(jasmineProbe);
            this.__IM.onExit((Object)this, "buildArgList$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "buildArgList$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __buildArgList(JasmineProbe probe) throws JasmineProbeException {
        LinkedList<String> args = new LinkedList<String>();
        if (probe instanceof JasmineStat) {
            JasmineStat stat = (JasmineStat)probe;
            args.add("stat");
            args.add("-name");
            if (stat.getFilter() != null && stat.getFilter().length() > 0) {
                args.add(stat.getFilter());
            }
            if (stat.getAttributes() != null) {
                for (int i = 0; i < stat.getAttributes().length; ++i) {
                    args.add(stat.getAttributes()[i]);
                }
            }
            if (probe.getRefreshPeriod() > 0) {
                args.add("-r");
                args.add("" + probe.getRefreshPeriod());
            }
        } else if (probe instanceof JasminePoll) {
            JasminePoll poll = (JasminePoll)probe;
            args.add("poll");
            args.add("-" + poll.getWhich());
            if (poll.getFilter() != null && poll.getFilter().length() > 0) {
                args.add(poll.getFilter());
            }
        } else {
            throw new JasmineProbeException("Probe type not supported");
        }
        if (probe.getPeriod() > 0) {
            args.add("-p");
            args.add("" + probe.getPeriod());
        }
        if (probe.getSeparator() != null && probe.getSeparator().length() > 0) {
            args.add("-s");
            args.add(probe.getSeparator());
        }
        args.add("-cmdid");
        args.add("" + probe.getId());
        if (probe.getTargetList().isEmpty()) {
            this.__getlogger().warn((Object)("No target for probe " + probe.getId()), new Object[0]);
            throw new JasmineProbeException("Probe has no target defined");
        }
        for (JasmineTarget target : probe.getTargetList()) {
            args.add("-target");
            args.add(target.getName());
        }
        if (probe.getOutputList().isEmpty()) {
            this.__getlogger().warn((Object)("No output for probe " + probe.getId()), new Object[0]);
            throw new JasmineProbeException("Probe has no output defined");
        }
        for (JasmineOutput output : probe.getOutputList()) {
            if (output instanceof EventswitchOutput) {
                EventswitchOutput eout = (EventswitchOutput)output;
                args.add("-jasmine");
                args.add("vm://MBeanCmd_dispatcher");
                continue;
            }
            if (output instanceof ConsoleOutput) {
                args.add("-console");
                continue;
            }
            if (!(output instanceof FileOutput)) continue;
            FileOutput fout = (FileOutput)output;
            args.add("-f");
            if (new File(fout.getPath()).isAbsolute()) {
                args.add(fout.getPath());
                continue;
            }
            args.add(JProp.getJonasBase() + File.separator + "monitoring" + File.separator + fout.getPath());
        }
        this.__getlogger().debug((Object)("arg list " + args), new Object[0]);
        return args.toArray(new String[args.size()]);
    }

    private int getNewProbeId() {
        int n;
        if (!this.__MgetNewProbeId) {
            return this.__getNewProbeId();
        }
        try {
            this.__IM.onEntry((Object)this, "getNewProbeId", new Object[0]);
            n = this.__getNewProbeId();
            this.__IM.onExit((Object)this, "getNewProbeId", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNewProbeId", throwable);
            throw throwable;
        }
        return n;
    }

    private int __getNewProbeId() {
        ProbeServiceImpl probeServiceImpl = this;
        int n = probeServiceImpl.__getprobeCount() + 1;
        probeServiceImpl.__setprobeCount(n);
        int ret = n;
        return ret;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("mbeanCmdList")) {
                this.__FmbeanCmdList = true;
            }
            if (set.contains("probeListeners")) {
                this.__FprobeListeners = true;
            }
            if (set.contains("probeCount")) {
                this.__FprobeCount = true;
            }
            if (set.contains("outputList")) {
                this.__FoutputList = true;
            }
            if (set.contains("startlist")) {
                this.__Fstartlist = true;
            }
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("probeList")) {
                this.__FprobeList = true;
            }
            if (set.contains("targetList")) {
                this.__FtargetList = true;
            }
            if (set.contains("probeConfig")) {
                this.__FprobeConfig = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("createOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput")) {
                this.__McreateOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput = true;
            }
            if (set.contains("changeOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput")) {
                this.__MchangeOutput$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput = true;
            }
            if (set.contains("removeOutput$java_lang_String")) {
                this.__MremoveOutput$java_lang_String = true;
            }
            if (set.contains("findOutput$java_lang_String")) {
                this.__MfindOutput$java_lang_String = true;
            }
            if (set.contains("getOutputs")) {
                this.__MgetOutputs = true;
            }
            if (set.contains("createTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget")) {
                this.__McreateTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget = true;
            }
            if (set.contains("changeTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget")) {
                this.__MchangeTarget$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget = true;
            }
            if (set.contains("removeTarget$java_lang_String")) {
                this.__MremoveTarget$java_lang_String = true;
            }
            if (set.contains("findTarget$java_lang_String")) {
                this.__MfindTarget$java_lang_String = true;
            }
            if (set.contains("getTargets")) {
                this.__MgetTargets = true;
            }
            if (set.contains("createProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe")) {
                this.__McreateProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe = true;
            }
            if (set.contains("changeProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe")) {
                this.__MchangeProbe$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe = true;
            }
            if (set.contains("removeProbe$int")) {
                this.__MremoveProbe$int = true;
            }
            if (set.contains("removeAllProbes")) {
                this.__MremoveAllProbes = true;
            }
            if (set.contains("startProbe$int")) {
                this.__MstartProbe$int = true;
            }
            if (set.contains("stopProbe$int")) {
                this.__MstopProbe$int = true;
            }
            if (set.contains("stopAllProbes")) {
                this.__MstopAllProbes = true;
            }
            if (set.contains("startAllProbes")) {
                this.__MstartAllProbes = true;
            }
            if (set.contains("getProbes")) {
                this.__MgetProbes = true;
            }
            if (set.contains("saveConfig$java_lang_String")) {
                this.__MsaveConfig$java_lang_String = true;
            }
            if (set.contains("loadConfig$java_lang_String")) {
                this.__MloadConfig$java_lang_String = true;
            }
            if (set.contains("addProbeListener$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbeListener")) {
                this.__MaddProbeListener$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbeListener = true;
            }
            if (set.contains("getMBeans$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget$java_lang_String")) {
                this.__MgetMBeans$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget$java_lang_String = true;
            }
            if (set.contains("publishChange$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe")) {
                this.__MpublishChange$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe = true;
            }
            if (set.contains("isTargetUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget")) {
                this.__MisTargetUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget = true;
            }
            if (set.contains("isOutputUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput")) {
                this.__MisOutputUsed$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineOutput = true;
            }
            if (set.contains("setTargetState$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget")) {
                this.__MsetTargetState$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineTarget = true;
            }
            if (set.contains("readConfig")) {
                this.__MreadConfig = true;
            }
            if (set.contains("saveConfigFile$java_io_OutputStream")) {
                this.__MsaveConfigFile$java_io_OutputStream = true;
            }
            if (set.contains("loadConfigFile$java_io_InputStream")) {
                this.__MloadConfigFile$java_io_InputStream = true;
            }
            if (set.contains("buildArgList$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe")) {
                this.__MbuildArgList$org_ow2_jasmine_monitoring_mbeancmd_api_JasmineProbe = true;
            }
            if (set.contains("getNewProbeId")) {
                this.__MgetNewProbeId = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

