/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.TreeMap;
import org.ow2.jasmine.monitoring.mbeancmd.CmdThread;
import org.ow2.jasmine.monitoring.mbeancmd.Command;
import org.ow2.jasmine.monitoring.mbeancmd.loader.CmdLoaderHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandDispatcher {
    protected Command cmd = null;
    private static final String COMMAND_DEFINITIONS = "META-INF/mbeancmd/commands.defs";
    private TreeMap<String, String> commands = null;
    private boolean isEmbedded = true;
    private CommandStatus status;
    private String errormessage = null;
    protected static Log logger = LogFactory.getLog(CommandDispatcher.class);

    protected CommandDispatcher() {
    }

    public static void main(String[] args) {
        CommandDispatcher.setClassLoader();
        CommandDispatcher dispatcher = new CommandDispatcher();
        dispatcher.setEmbedded(false);
        dispatcher.init(args);
    }

    public static int start(String[] args) {
        logger.debug((Object)"start Command Dispatcher", new Object[0]);
        CommandDispatcher dispatcher = new CommandDispatcher();
        dispatcher.setEmbedded(true);
        dispatcher.setStarted();
        return dispatcher.init(args);
    }

    public void stopCommand() {
        if (this.cmd != null) {
            this.cmd.stop();
        }
    }

    public int init(String[] args) {
        String cmdName = null;
        String[] cmdArgs = null;
        this.cmd = null;
        if (this.commands == null) {
            this.findCommands();
        }
        if (args.length > 0) {
            cmdName = args[0];
            this.cmd = this.getCommand(cmdName);
        }
        if (this.cmd == null) {
            if (this.isEmbedded) {
                return -1;
            }
            cmdName = "help";
            this.cmd = this.getCommand(cmdName);
            if (this.cmd == null) {
                logger.error((Object)"Cannot exec this command", new Object[0]);
                return -1;
            }
        } else if (args.length > 1) {
            cmdArgs = new String[args.length - 1];
            System.arraycopy(args, 1, cmdArgs, 0, args.length - 1);
        }
        this.cmd.setArgs(cmdName, cmdArgs);
        return this.cmd.exec(this);
    }

    public Command getCommand(String name) {
        Command cmd = null;
        String cname = this.commands.get(name);
        if (cname == null) {
            logger.error((Object)("Cannot find command " + name), new Object[0]);
            return cmd;
        }
        try {
            Class<?> cl = this.loadClass(cname);
            cmd = (Command)cl.newInstance();
        }
        catch (Exception e) {
            logger.warn((Object)"Error when trying to instanciate {0} {1}: {2}", new Object[]{name, cname, e});
        }
        return cmd;
    }

    public String[] getAvailableCommands() {
        if (this.commands == null) {
            return null;
        }
        String[] cmds = new String[this.commands.size()];
        cmds = this.commands.keySet().toArray(cmds);
        return cmds;
    }

    private String getRadix(String fqn) {
        String radix = fqn.substring(fqn.lastIndexOf(".") + 1);
        return radix;
    }

    private void findCommands() {
        try {
            InputStreamReader in0 = this.getInputStreamReader(COMMAND_DEFINITIONS);
            if (in0 != null) {
                BufferedReader in = new BufferedReader(in0);
                String command = null;
                while ((command = in.readLine()) != null) {
                    if ("".equals(command) || command.indexOf("#") == 0) continue;
                    try {
                        Class<?> cl = this.loadClass(command);
                        if (!Command.class.isAssignableFrom(cl)) continue;
                        if (this.commands == null) {
                            this.commands = new TreeMap();
                        }
                        this.commands.put(this.getRadix(command).toLowerCase(), command);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
        catch (IOException e) {
            System.err.println("Cannot access META-INF/mbeancmd/commands.defs");
            e.printStackTrace();
        }
    }

    protected InputStreamReader getInputStreamReader(String name) throws IOException {
        InputStreamReader isr = null;
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
            isr = new InputStreamReader(is);
        }
        catch (Exception e) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
            isr = new InputStreamReader(is);
        }
        return isr;
    }

    protected Class<?> loadClass(String cname) throws ClassNotFoundException {
        return Class.forName(cname);
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public void setEmbedded(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }

    private static void setClassLoader() {
        URL[] urls = CmdLoaderHelper.getXClasspath();
        if (urls != null) {
            URLClassLoader urlLoader = new URLClassLoader(urls);
            Thread.currentThread().setContextClassLoader(urlLoader);
        }
    }

    public void setStarted() {
        logger.debug((Object)"", new Object[0]);
        this.status = CommandStatus.STARTED;
        this.updateThreadStatus();
    }

    public void setFailed() {
        logger.debug((Object)"", new Object[0]);
        this.status = CommandStatus.FAILED;
        this.errormessage = "mbeancmd unknown error";
        this.updateThreadStatus();
    }

    public void setFailed(String error) {
        logger.debug((Object)error, new Object[0]);
        if (error == null) {
            Thread.dumpStack();
        }
        this.status = CommandStatus.FAILED;
        this.errormessage = error;
        this.updateThreadStatus();
    }

    public void setRunning() {
        logger.debug((Object)"", new Object[0]);
        this.status = CommandStatus.RUNNING;
        this.updateThreadStatus();
    }

    public void setStopped() {
        logger.debug((Object)"", new Object[0]);
        this.status = CommandStatus.STOPPED;
        this.updateThreadStatus();
    }

    private void updateThreadStatus() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof CmdThread) {
            CmdThread cmdThread = (CmdThread)currentThread;
            cmdThread.setErrorMessage(this.errormessage);
            cmdThread.setCmdStatus(this.status.toString());
        } else {
            logger.debug((Object)"Status not propagated", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommandStatus {
        STOPPED,
        FAILED,
        RUNNING,
        STARTED;

    }
}

