/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.osgi.internal;

import org.ow2.jasmine.monitoring.mbeancmd.CmdThread;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.api.JasmineProbe;
import org.ow2.jasmine.monitoring.mbeancmd.osgi.internal.JProbeCommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.osgi.internal.ProbeServiceImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JProbeCmdThread
extends CmdThread {
    private Log logger = LogFactory.getLog(this.getClass());
    protected CommandDispatcher commandDispatcher = null;
    protected JasmineProbe probe = null;
    protected String error = null;
    protected ProbeServiceImpl probeservice;

    public JProbeCmdThread(String[] args, long delay, JasmineProbe probe, ProbeServiceImpl probeservice) {
        super(args, delay);
        this.probe = probe;
        this.probeservice = probeservice;
    }

    public void setDispatcher(CommandDispatcher disp) {
        this.commandDispatcher = disp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.delay != 0L) {
            long time = System.currentTimeMillis();
            JProbeCmdThread jProbeCmdThread = this;
            synchronized (jProbeCmdThread) {
                while (System.currentTimeMillis() < time + this.delay) {
                    try {
                        this.wait(this.delay);
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                    }
                }
            }
        }
        this.setContextClassLoader(this.getClass().getClassLoader());
        JProbeCommandDispatcher.start(this.commandArgs, this);
    }

    public void tryStop() {
        if (this.commandDispatcher != null) {
            this.commandDispatcher.stopCommand();
        }
    }

    public void setCmdStatus(String cmdStatus) {
        this.cmdStatus = cmdStatus;
        if (cmdStatus.equals(CommandDispatcher.CommandStatus.STARTED.toString())) {
            this.probe.setState(1);
        } else if (cmdStatus.equals(CommandDispatcher.CommandStatus.RUNNING.toString())) {
            this.probe.setState(2);
        } else if (cmdStatus.equals(CommandDispatcher.CommandStatus.FAILED.toString())) {
            this.probe.setState(3);
            this.probe.setError(this.getErrorMessage());
        } else if (cmdStatus.equals(CommandDispatcher.CommandStatus.STOPPED.toString())) {
            this.probe.setState(0);
        }
        this.probeservice.publishChange(this.probe);
    }
}

