/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JProbeCommandDispatcher.java 8194 2011-05-18 15:15:34Z jlegrand $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.osgi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.osgi.framework.BundleContext;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;

/**
 * Avoids modifications in mbeancmd standalone.
 * This class should be removed when JasmineProbe 3.0 is available.
 * @author durieuxp
 */
public class JProbeCommandDispatcher extends CommandDispatcher {

    /**
     * Bundle context.
     */
    private static BundleContext context = null;

    public JProbeCommandDispatcher() {

    }

    /**
     * Set a bundle context
     * @param c bundle context
     */
    public static void setContext(final BundleContext c) {
        context = c;
    }

    /**
     * Delete the reference to the bundle context.
     */
    public static void removeContext() {
        context = null;
    }

    /**
     * Overwrite the start method to instanciate this class
     * in place of the standard mbeancmd one.
     * @param args Arguments of the command, including the command itself at the
     *            first position.
     *
     * @return 0 if succeeded, an error code otherwise.
     */
    public static int start(final String[] args, JProbeCmdThread cmd) {
        JProbeCommandDispatcher dispatcher;
        logger.debug("start Command Dispatcher");
        dispatcher = new JProbeCommandDispatcher();
        dispatcher.setEmbedded(true);
        dispatcher.setStarted();
        // TODO Use a simple constructor instead of this static method ?
        if (cmd != null) {
            cmd.setDispatcher(dispatcher);
        }
        return dispatcher.init(args);
    }

    /**
     * Return an inputStreamReader for the specified resource, by using the bundle context.
     * @param name the resource name
     * @return an inputStreamReader for the specified resource
     * @throws IOException if an I/O exception occurs
     */
    @Override
    protected InputStreamReader getInputStreamReader(final String name) throws IOException {
        if (context == null) {
            return super.getInputStreamReader(name);
        }
        InputStream commandDefsInputStream =
            context.getBundle().getResource(name).openStream();
        return new InputStreamReader(commandDefsInputStream);
    }

    /**
     * Load and return a class for a given class name, by using the bundle context.
     * @param cname a class name
     * @return a loaded class for a given class name
     * @throws ClassNotFoundException if the class cannot be found
     */
    @Override
    protected Class<?> loadClass(final String cname) throws ClassNotFoundException {
        if(context == null) {
            return super.loadClass(cname);
        }
        return context.getBundle().loadClass(cname);
    }


}
