/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class Iner
implements Runnable {
    private LineNumberReader source = null;
    private PipedOutputStream sink = null;
    private PrintWriter wsink = null;
    private Log logger = LogFactory.getLog(Iner.class);

    public Iner(InputStream in) {
        this.source = new LineNumberReader(new InputStreamReader(in));
        this.setSink(null);
    }

    public Iner(File file) throws FileNotFoundException {
        this.source = new LineNumberReader(new FileReader(file));
        this.setSink(null);
    }

    public void setSink(PipedOutputStream sink) {
        if (sink == null) {
            this.setSink(new PipedOutputStream());
        } else {
            if (this.wsink != null) {
                try {
                    this.wsink.close();
                    this.sink.close();
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Error while closing sink : {0}", new Object[]{e});
                }
            }
            this.sink = sink;
            this.wsink = new PrintWriter((Writer)new OutputStreamWriter(sink), true);
        }
    }

    public PipedOutputStream getSink() {
        return this.sink;
    }

    public void run() {
        boolean goOn = true;
        while (goOn) {
            try {
                String ln = this.source.readLine();
                if (ln == null) {
                    goOn = false;
                    continue;
                }
                this.wsink.println(ln);
                this.wsink.flush();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                goOn = false;
            }
        }
        this.wsink.flush();
        this.wsink.close();
    }
}

