/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.event.processor.outer;

import java.io.File;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import org.ow2.jasmine.event.processor.ProcessContext;
import org.ow2.jasmine.event.processor.ProcessContextException;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.graph.Grapher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class OuterContext
implements ProcessContext {
    private static Log logger = LogFactory.getLog(OuterContext.class);
    Outer outer = null;
    private String header = null;
    private String separator = ";";
    private PrintStream pout = null;
    private String outputFilePath;
    private String graphDef;

    public final String getOutputFilePath() {
        return this.outputFilePath;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public PrintStream getPout() {
        return this.pout;
    }

    public void setOutputFilePath(String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    public void setGraphDef(String graphDef) {
        this.graphDef = graphDef;
    }

    public final String getGraphDef() {
        return this.graphDef;
    }

    public void start() throws ProcessContextException {
        try {
            this.pout = this.getPrintStream(this.getOutputFilePath());
        }
        catch (IOException e) {
            logger.error((Object)("Unable to get a print stream for " + this.getOutputFilePath()), new Object[]{e});
            throw new ProcessContextException("Unable to get a print stream for " + this.getOutputFilePath(), (Throwable)e);
        }
        if (this.getGraphDef() != null) {
            Grapher gr;
            PipedOutputStream sink = new PipedOutputStream();
            this.outer.setSink(sink);
            try {
                gr = new Grapher(sink, this.getGraphDef());
            }
            catch (IOException e) {
                logger.error((Object)("Unable to create a grapher for " + this.getGraphDef()), new Object[]{e});
                throw new ProcessContextException("Unable to create a grapher for " + this.getGraphDef(), (Throwable)e);
            }
            gr.start();
        }
        new Thread((Runnable)this.outer).start();
    }

    public void stop() {
    }

    private PrintStream getPrintStream(String outputFilePath) throws IOException {
        PipedOutputStream out = new PipedOutputStream();
        this.outer = outputFilePath != null ? new Outer(out, new File(outputFilePath)) : new Outer(out, System.out);
        return new PrintStream(out);
    }
}

